/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.figis.tmplugin.repository;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import org.gcube.data.figis.tmplugin.FigisPlugin;
import org.gcube.data.figis.tmplugin.dbconnection.FigisTable;
import org.gcube.data.figis.tmplugin.repository.Repository;
import org.gcube.data.figis.tmplugin.repository.Summary;
import org.gcube.data.figis.tmplugin.repository.iterators.FigisRecord;
import org.gcube.data.figis.tmplugin.repository.iterators.RecordIterator;
import org.gcube.data.figis.tmplugin.requests.Request;
import org.gcube.data.figis.tmplugin.utils.FigisTreeGenerator;
import org.gcube.data.figis.tmplugin.utils.Utils;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.dsl.Streams;
import org.gcube.data.streams.exceptions.StreamException;
import org.gcube.data.streams.generators.Generator;
import org.gcube.data.tmf.api.exceptions.UnknownTreeException;
import org.gcube.data.trees.data.Tree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseRepository
implements Repository {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(BaseRepository.class);
    private transient String name;
    private transient String description;
    private FigisTreeGenerator binder;

    public BaseRepository(Request request) throws Exception {
        this.description = request.getDescription();
        this.name = request.getName();
        this.binder = new FigisTreeGenerator(request);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public Tree get(String id) throws UnknownTreeException, Exception {
        log.trace("Get figis records by ID {}", (Object)id);
        FigisRecord record = null;
        try {
            FigisTable figisTable = new FigisTable();
            record = figisTable.getRecordByID(id);
            return this.binder.bind(record);
        }
        catch (Exception e) {
            throw new UnknownTreeException(id, (Throwable)e);
        }
    }

    @Override
    public Stream<Tree> getRecords() throws UnknownTreeException, Exception {
        log.trace("Get all figis records");
        RecordIterator records = new RecordIterator();
        Generator<FigisRecord, Tree> parser = new Generator<FigisRecord, Tree>(){

            public Tree yield(FigisRecord record) {
                try {
                    return BaseRepository.this.binder.bind(record);
                }
                catch (Exception e) {
                    throw new StreamException();
                }
            }
        };
        return Streams.pipe((Stream)records).through((Generator)parser);
    }

    @Override
    public Summary summary() throws Exception {
        log.trace("update summary");
        Calendar lastUpdate = null;
        try {
            lastUpdate = Utils.lastupdate();
        }
        catch (Exception e) {
            log.error("could not retrieve last update", (Throwable)e);
        }
        RecordIterator records = new RecordIterator();
        long cardinality = 0L;
        while (records.hasNext()) {
            try {
                records.next();
                ++cardinality;
            }
            catch (Exception e) {
                log.error("could not count record", (Throwable)e);
            }
        }
        return new Summary(lastUpdate, cardinality);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (FigisPlugin.jdbc == null || FigisPlugin.dbLogin == null || FigisPlugin.dbPassword == null || FigisPlugin.baseUrl == null || FigisPlugin.extractAllCsv == null || FigisPlugin.reinitialize == null) {
            Utils.getRuntimeResource();
        }
    }
}

