/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.figis.tmplugin;

import java.util.Collections;
import java.util.List;
import org.gcube.data.figis.tmplugin.FigisPlugin;
import org.gcube.data.figis.tmplugin.FigisReader;
import org.gcube.data.figis.tmplugin.FigisSource;
import org.gcube.data.figis.tmplugin.Lifecycle;
import org.gcube.data.figis.tmplugin.ProductionProvider;
import org.gcube.data.figis.tmplugin.RepositoryProvider;
import org.gcube.data.figis.tmplugin.repository.Repository;
import org.gcube.data.figis.tmplugin.requests.FigisRequest;
import org.gcube.data.figis.tmplugin.requests.RequestBinder;
import org.gcube.data.figis.tmplugin.utils.Utils;
import org.gcube.data.tmf.api.SourceBinder;
import org.gcube.data.tmf.api.SourceLifecycle;
import org.gcube.data.tmf.api.SourceReader;
import org.gcube.data.tmf.api.exceptions.InvalidRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class FigisBinder
implements SourceBinder {
    private static Logger log = LoggerFactory.getLogger(FigisBinder.class);
    private RepositoryProvider provider;

    public FigisBinder() {
        this(new ProductionProvider());
        log.trace("FigisBinder");
    }

    FigisBinder(RepositoryProvider p) {
        this.provider = p;
    }

    public List<? extends FigisSource> bind(Element request) throws InvalidRequestException, Exception {
        if (FigisPlugin.jdbc == null || FigisPlugin.dbLogin == null || FigisPlugin.dbPassword == null || FigisPlugin.baseUrl == null || FigisPlugin.extractAllCsv == null || FigisPlugin.reinitialize == null) {
            Utils.getRuntimeResource();
        }
        Utils.createTableUpdates();
        Utils.createTableFigis();
        FigisRequest figisRequest = new RequestBinder().bind(request);
        Repository repository = this.provider.newRepository(figisRequest);
        FigisSource source = new FigisSource(figisRequest.getName());
        source.setName(figisRequest.getName());
        source.setDescription(figisRequest.getDescription());
        source.setReader((SourceReader)new FigisReader(source, repository));
        source.setLifecycle((SourceLifecycle)new Lifecycle(source));
        log.trace("created source {}" + source.id());
        return Collections.singletonList(source);
    }
}

