package org.gcube.data.figis.tmplugin.utils;


import static org.gcube.resources.discovery.icclient.ICFactory.clientFor;
import static org.gcube.resources.discovery.icclient.ICFactory.queryFor;

import java.io.IOException;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;

import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.ServiceEndpoint.AccessPoint;
import org.gcube.common.resources.gcore.ServiceEndpoint.Property;
import org.gcube.common.utils.encryption.StringEncrypter;
import org.gcube.data.figis.tmplugin.FigisPlugin;
import org.gcube.data.figis.tmplugin.dbconnection.ConnectionPool;
import org.gcube.data.figis.tmplugin.dbconnection.ConnectionPoolException;
import org.gcube.data.figis.tmplugin.dbconnection.FigisTable;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author "Valentina Marioli valentina.marioli@isti.cnr.it"
 *
 */
public class Utils {
	private static Logger log = LoggerFactory.getLogger(Utils.class);
	/**
	 * Return true if a table exists
	 */
	public static boolean SQLTableExists(String tableName) {
		boolean exists = false;
		ConnectionPool pool = null;
		Connection con = null;
		ResultSet results = null;
		try {
			pool = ConnectionPool.getConnectionPool();
			con = pool.getConnection();
			Statement statement = con.createStatement();

			String sqlText = "SELECT tables.table_name FROM information_schema.tables WHERE table_name = '" + tableName + "'";    
			results = statement.executeQuery(sqlText);
			if (results.next()){
				//				logger.trace(tableName + " already exists");
				exists = true;
			}

			else{
				//				logger.trace(tableName + " does not exists");
				exists = false;
			}

		} catch (SQLException e) {
			log.error("SQLException", e);
		} catch (ConnectionPoolException e) {
			log.error("ConnectionPoolException", e);
		}finally {
			if ((pool!=null) && (con!=null)){
				pool.releaseConnection(con);
			}
			try {
				if (results != null) {
					results.close();
				}
			} catch (SQLException ex) {
				log.error("sql Error", ex);
			}
		} 
		return exists;
	}


	/**
	 * Create schema by class Request
	 */
	public static String toSchema(Class<?> clazz) {

		final StringWriter writer = new StringWriter();

		SchemaOutputResolver resolver = new SchemaOutputResolver() {

			public Result createOutput(String namespaceUri, String suggestedFileName) throws IOException {
				Result result = new StreamResult(writer);
				result.setSystemId("anything");
				return result;
			}
		};

		try {
			JAXBContext ctxt = JAXBContext.newInstance(clazz);
			ctxt.generateSchema(resolver);
		} catch(Exception e) {
			throw new RuntimeException(e);
		}
		return writer.toString();
	}




	//get RuntimeResource 
	public static void getRuntimeResource() {

		SimpleQuery query = queryFor(ServiceEndpoint.class);

		query.addCondition("$resource/Profile/Category/text() eq 'DataSource' and $resource/Profile/Name eq 'Figis' ");

		DiscoveryClient<ServiceEndpoint> client = clientFor(ServiceEndpoint.class);

		List<ServiceEndpoint> resources = client.submit(query);

		if(resources.size() != 0) {	   
			try {
				initialize(resources.get(0));
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		

	}

	/**
	 * inizialize Runtime Resource
	 */
	public static void initialize(ServiceEndpoint res) throws Exception {
		try{
			log.trace("Retrieving Runtime Resource...");
			for (AccessPoint ap:res.profile().accessPoints()) {
				if (ap.name().equals("rest")) {
					FigisPlugin.baseUrl = ap.address();				
					Iterator<Property> properties = ap.properties().iterator();
					while(properties.hasNext()) {
						Property p = properties.next();		
						if (p.name().equals("extractAllCsv")){							
							FigisPlugin.extractAllCsv = p.value();
						} else if (p.name().equals("reinitialize")){							
							FigisPlugin.reinitialize = p.value();
						}
					}	
				}
				if (ap.name().equals("jdbc")) {								
					FigisPlugin.dbPassword = StringEncrypter.getEncrypter().decrypt(ap.password());					
					FigisPlugin.jdbc = ap.address();				
					FigisPlugin.dbLogin = ap.username();					

				}
			}	
		}catch (Exception e) {
			log.error("Error retrieving Runtime Resource");
		}
		log.trace("Retrieved Runtime Resource");

	}

	/**
	 * if table is created with success, set last update date
	 */
	public static void createTableFigis() {

		try{
			if (!(Utils.SQLTableExists(FigisPlugin.table))) {		
				FigisTable figis = new FigisTable();
				if (figis.create()){
					Utils.setlastupdate();
//					System.out.println("Table figis created with success!");
					log.info("Table figis created with success!");
				}
				else
					log.error("Error creating table figis.");
				//			Utils.downloadCsv();
			}else{
//				System.out.println("Table figis already exists, skip creation table.");
				log.info("Table figis already exists, skip creation table.");
			}
		}catch (Exception e) {
			log.error("Error creating table figis ", e);
		}

	}

	/**
	 * create table updates
	 */
	public static void createTableUpdates() {

		try{
			if (!(Utils.SQLTableExists(FigisPlugin.tableUpdates))) {		
				FigisTable figis = new FigisTable();
				if (figis.createTabUpdates())
					log.info("Table " + FigisPlugin.tableUpdates + " created with success!");
				else
					log.error("Error creating table " + FigisPlugin.tableUpdates);
				//				Utils.downloadCsv();
			}else
				log.info("Table " + FigisPlugin.tableUpdates + " already exists, skip creation table.");
		}catch (Exception e) {
			log.error("Error creating table  " + FigisPlugin.tableUpdates, e);
		}
	}


	/**
	 * Set last update date
	 */
	public static void setlastupdate() {

		log.trace("set last update date");
		ConnectionPool pool = null;
		Connection con = null;
		boolean result;

		try {
			pool = ConnectionPool.getConnectionPool();
			con = pool.getConnection();

			Date date = new Date();
			long dt = date.getTime();
			java.sql.Date today = new java.sql.Date (dt);
			String query = "insert into updates (date) values ('" + today + "')";    	

			result =  pool.insertPreStatement(query);
			if (!result){
				log.info("problem setting last update date");
			}
		} catch (ConnectionPoolException e) {
			log.error("ConnectionPoolException", e);
		} catch (SQLException e) {
			log.error("SQLException", e);
		}finally {
			if ((pool!=null) && (con!=null)){
				pool.releaseConnection(con);
			}			
		} 
	}


	/**
	 * get last update date
	 */
	public static Calendar lastupdate() {

		log.trace("get last update date");
		ConnectionPool pool = null;
		Connection con = null;
		ResultSet results = null;
		Calendar lastUpdate = null;

		try {
			pool = ConnectionPool.getConnectionPool();
			con = pool.getConnection();
			Statement statement = con.createStatement();

			String query = "select date from updates where id= (select max(id) from updates)";    
			results = statement.executeQuery(query);

			if (results.next()){
				lastUpdate = DateToCalendar(results.getDate(1));			
			}	

		} catch (SQLException e) {
			log.error("SQLException", e);
		} catch (ConnectionPoolException e) {
			log.error("ConnectionPoolException", e);
		}finally {
			if ((pool!=null) && (con!=null)){
				pool.releaseConnection(con);
			}
			try {
				if (results != null) {
					results.close();
				}
			} catch (SQLException ex) {
				log.error("sql Error", ex);
			}
		} 
		return lastUpdate;
	}

	/**
	 * convert a date to calendar
	 */
	public static Calendar DateToCalendar(Date date){ 
		Calendar cal = null;
		try {   
			DateFormat formatter = new SimpleDateFormat("yyyyMMdd");
			date = (Date)formatter.parse(date.toString()); 
			cal=Calendar.getInstance();
			cal.setTime(date);
		}
		catch (ParseException e){
			log.error("Exception",e);  
		}  
		return cal;
	}

}

