package org.gcube.data.figis.tmplugin;

import static java.util.Collections.singletonList;

import java.util.List;

import org.gcube.data.figis.tmplugin.repository.Repository;
import org.gcube.data.figis.tmplugin.requests.FigisRequest;
import org.gcube.data.figis.tmplugin.requests.RequestBinder;
import org.gcube.data.figis.tmplugin.utils.Utils;
import org.gcube.data.tmf.api.SourceBinder;
import org.gcube.data.tmf.api.exceptions.InvalidRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

/**
 * @author "Valentina Marioli valentina.marioli@isti.cnr.it"
 *
 */

public class FigisBinder implements SourceBinder {

	private static Logger log = LoggerFactory.getLogger(FigisBinder.class);

	private RepositoryProvider provider;

	public FigisBinder() {	
		this(new ProductionProvider());
		log.trace("FigisBinder");
	}

	//backdoor for testing
	FigisBinder(RepositoryProvider p) {
		provider=p;
	}

	@Override
	public List<? extends FigisSource> bind(Element request)
			throws InvalidRequestException, Exception {

		//get runtime resource
		if ((FigisPlugin.jdbc==null) || (FigisPlugin.dbLogin==null) || (FigisPlugin.dbPassword==null) || (FigisPlugin.baseUrl==null) || (FigisPlugin.extractAllCsv==null) || (FigisPlugin.reinitialize==null))
			Utils.getRuntimeResource();
		
		//create Table if it doesn't exist
		Utils.createTableUpdates();
		Utils.createTableFigis();
		
		//parse parameters
		FigisRequest figisRequest = new RequestBinder().bind(request);
		Repository repository = provider.newRepository(figisRequest);

		FigisSource source = new FigisSource(figisRequest.getName());	
		//set repository name
		source.setName(figisRequest.getName());
		//set repository description
		source.setDescription(figisRequest.getDescription());		
		source.setReader(new FigisReader(source,repository));
		source.setLifecycle(new Lifecycle(source));

		log.trace("created source {}"+source.id());

		return singletonList(source);


	}

}
