/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.figis.tmplugin.utils;

import java.io.Serializable;
import org.gcube.data.figis.tmplugin.RepositoryProvider;
import org.gcube.data.figis.tmplugin.repository.iterators.FigisRecord;
import org.gcube.data.figis.tmplugin.requests.Request;
import org.gcube.data.trees.data.Nodes;
import org.gcube.data.trees.data.Tree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FigisTreeGenerator
implements Serializable {
    private static final long serialVersionUID = -8037198825787888863L;
    private static final String URLFAO = "http://www.fao.org/";
    private static final Logger log = LoggerFactory.getLogger(FigisTreeGenerator.class);

    public FigisTreeGenerator(Request req) {
        log.info("Figis Tree Generator");
    }

    public FigisTreeGenerator(RepositoryProvider p) {
    }

    public Tree bind(FigisRecord record) throws Exception {
        Tree tree = null;
        try {
            tree = new Tree(record.getThree_alpha_cod());
            tree.add(Nodes.e((String)"title", (Object)(String.valueOf(record.scientific_name) + " " + record.personal_author + " - Fact sheet")));
            tree.add(Nodes.e((String)"three_alpha_code", (Object)record.getThree_alpha_cod()));
            tree.add(Nodes.e((String)"name_en", (Object)record.name_en));
            tree.add(Nodes.e((String)"name_fr", (Object)record.name_fr));
            tree.add(Nodes.e((String)"name_es", (Object)record.name_es));
            tree.add(Nodes.e((String)"images", (Object)(URLFAO + record.images)));
            tree.add(Nodes.e((String)"scientific_name", (Object)record.scientific_name));
            tree.add(Nodes.e((String)"family", (Object)record.family));
            tree.add(Nodes.e((String)"personal_author", (Object)record.personal_author));
            tree.add(Nodes.e((String)"year", (Object)record.year));
            tree.add(Nodes.e((String)"diagnostic_features", (Object)record.diagnostic_features));
            tree.add(Nodes.e((String)"area_text", (Object)record.area_text));
            tree.add(Nodes.e((String)"habitat_bio", (Object)record.habitat_bio));
            tree.add(Nodes.e((String)"interest_fisheries", (Object)record.interest_fisheries));
            tree.add(Nodes.e((String)"local_names", (Object)record.local_names));
            tree.add(Nodes.e((String)"factsheet_url", (Object)record.factsheet_url));
            tree.add(Nodes.e((String)"factsheet_id", (Object)record.factsheet_id));
        }
        catch (Exception e) {
            log.error("Error creating Tree in Figis Plugin ", (Throwable)e);
        }
        return tree;
    }
}

