/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.figis.tmplugin.dbconnection;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.gcube.data.figis.tmplugin.dbconnection.ConnectionPool;
import org.gcube.data.figis.tmplugin.dbconnection.ConnectionPoolException;
import org.gcube.data.figis.tmplugin.repository.iterators.FigisRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FigisTable {
    private static Logger log = LoggerFactory.getLogger(FigisTable.class);
    private static final String SEPARATEDBY = ",";
    private static final char TEXTDELIMITER = '\"';
    private ArrayList<String> fields = null;
    private File tempFolder = null;

    public Boolean create() {
        String csvFile = this.getCsv();
        if (csvFile != null) {
            try {
                try {
                    int[] dimension = this.getTableDimension(csvFile);
                    this.createTable(csvFile, dimension);
                }
                catch (SQLException e) {
                    Boolean bl = false;
                    if (this.tempFolder != null) {
                        this.clearTmp(this.tempFolder);
                    }
                    return bl;
                }
                catch (IOException e) {
                    Boolean bl = false;
                    if (this.tempFolder != null) {
                        this.clearTmp(this.tempFolder);
                    }
                    return bl;
                }
            }
            finally {
                if (this.tempFolder != null) {
                    this.clearTmp(this.tempFolder);
                }
            }
        }
        return true;
    }

    private String getCsv() {
        try {
            URL url = new URL("http://figisapps.fao.org/vrmf/samples/services/species/FS/extract/all.csv");
            this.tempFolder = File.createTempFile("figis-folder", "");
            this.tempFolder.delete();
            this.tempFolder.mkdir();
            String csvFile = this.tempFolder + "/figis.csv";
            if (this.downloadFromUrl(url, csvFile)) {
                return csvFile;
            }
        }
        catch (MalformedURLException e) {
            log.error("MalformedURLException", (Throwable)e);
        }
        catch (IOException e) {
            log.error("IOException", (Throwable)e);
        }
        return null;
    }

    private int[] getTableDimension(String csvFile) throws SQLException, IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(csvFile));
        int[] maxDimension = new int[]{};
        int size = 0;
        while ((line = reader.readLine()) != null) {
            ArrayList<String> tokens = this.getToken(line, size);
            if (size == 0) {
                size = tokens.size();
                maxDimension = new int[size];
                continue;
            }
            int i = 0;
            while (i < size - 1) {
                if (tokens.get(i).length() > maxDimension[i]) {
                    maxDimension[i] = tokens.get(i).length();
                }
                ++i;
            }
        }
        return maxDimension;
    }

    private void clearTmp(File f) {
        if (f.exists()) {
            File[] fileArray = f.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File c = fileArray[n2];
                if (c.isDirectory()) {
                    this.clearTmp(c);
                }
                c.delete();
                ++n2;
            }
            f.delete();
        }
    }

    private boolean downloadFromUrl(URL url, String string) throws IOException {
        boolean flag = false;
        log.info("Downloading " + string);
        InputStream is = null;
        FileOutputStream fos = null;
        try {
            int len;
            URLConnection urlConn = url.openConnection();
            is = urlConn.getInputStream();
            fos = new FileOutputStream(string);
            byte[] buffer = new byte[4096];
            while ((len = is.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
            flag = true;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
            }
        }
        return flag;
    }

    private ArrayList<String> getToken(String line, int size) throws SQLException, IOException {
        ArrayList<String> tokens = new ArrayList<String>();
        Boolean complex = false;
        StringTokenizer st = null;
        st = new StringTokenizer(line, SEPARATEDBY, true);
        StringBuilder complexLine = null;
        int countDelimiter = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.charAt(0) == '\"') {
                complexLine = new StringBuilder();
                complex = true;
            }
            if (token.charAt(token.length() - 1) == '\"') {
                char preEnd = token.charAt(token.length() - 2);
                complexLine.append(token);
                if (preEnd == '\"' && token.charAt(token.length() - 3) != '\"') continue;
                complex = false;
                countDelimiter = 0;
                String a = complexLine.substring(1, complexLine.length() - 1);
                String newLine = a.toString().replace("\"\"", "\"");
                tokens.add(newLine);
                continue;
            }
            if (complex.booleanValue()) {
                complexLine.append(token);
                continue;
            }
            if (token.equals(SEPARATEDBY)) {
                if (++countDelimiter <= 1) continue;
                tokens.add("");
                continue;
            }
            if (token.equals(SEPARATEDBY)) continue;
            countDelimiter = 0;
            tokens.add(token);
        }
        if (tokens.size() < size) {
            tokens.add("");
        }
        return tokens;
    }

    private boolean createTable(String csvFile, int[] dimension) throws SQLException, IOException {
        log.info("Creating table figis... ");
        ConnectionPool pool = null;
        Connection con = null;
        PreparedStatement stmtInsert = null;
        try {
            try {
                String line;
                pool = ConnectionPool.getConnectionPool();
                con = pool.getConnection();
                BufferedReader reader = new BufferedReader(new FileReader(csvFile));
                Boolean firstLine = true;
                int size = 0;
                while ((line = reader.readLine()) != null) {
                    ArrayList<String> token = this.getToken(line, size);
                    String query = null;
                    if (firstLine.booleanValue()) {
                        size = token.size();
                        this.fields = token;
                        query = this.createTableQuery(dimension);
                        firstLine = false;
                        boolean result = pool.insertPreStatement(query);
                        if (result) continue;
                        log.error("problem creating table");
                        continue;
                    }
                    query = this.createInsertQuery(token);
                    if (pool.preStatement(query, token, stmtInsert)) continue;
                    log.error("error ");
                }
            }
            catch (ConnectionPoolException e) {
                log.error("ConnectionPoolException", (Throwable)e);
                if (pool != null && con != null) {
                    pool.releaseConnection(con);
                }
            }
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
        return true;
    }

    private String createInsertQuery(ArrayList<String> token) {
        StringBuilder query = new StringBuilder();
        Boolean first = true;
        query.append("insert into figis (");
        for (String field : this.fields) {
            if (!first.booleanValue()) {
                query.append(", ");
            } else {
                first = false;
            }
            query.append(field);
        }
        query.append(")");
        query.append(" values (");
        first = true;
        int i = 0;
        while (i < token.size()) {
            if (!first.booleanValue()) {
                query.append(", ");
            } else {
                first = false;
            }
            query.append("?");
            ++i;
        }
        query.append(")");
        return query.toString();
    }

    private String createTableQuery(int[] dimension) {
        Boolean firstElement = true;
        StringBuilder query = new StringBuilder();
        query.append("create table figis (");
        int i = 0;
        for (String field : this.fields) {
            if (dimension[i] < 1) {
                dimension[i] = 1;
            }
            if (firstElement.booleanValue()) {
                String newField = field.replace("3", "three");
                this.fields.set(i, newField);
                query.append(newField);
                query.append(" varchar(" + dimension[i] + ") NOT NULL PRIMARY KEY");
                firstElement = false;
            } else {
                query.append(", ");
                query.append(field);
                query.append(" varchar(" + dimension[i] + ")");
            }
            ++i;
        }
        query.append(")");
        return query.toString();
    }

    public ResultSet getAllRecords() {
        ConnectionPool pool = null;
        Connection con = null;
        ResultSet results = null;
        try {
            try {
                pool = ConnectionPool.getConnectionPool();
                con = pool.getConnection();
                String query = "select * from figis";
                results = pool.selectPreStatement(query);
            }
            catch (Throwable e) {
                log.error("general Error", e);
                if (pool != null && con != null) {
                    pool.releaseConnection(con);
                }
            }
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
        return results;
    }

    public FigisRecord getRecordByID(String id) {
        log.info("getRecordByID " + id);
        ConnectionPool pool = null;
        Connection con = null;
        ResultSet result = null;
        FigisRecord record = null;
        try {
            try {
                pool = ConnectionPool.getConnectionPool();
                con = pool.getConnection();
                String three_alpha_code = "%" + id + "%";
                String query = "select * from figis where UPPER(three_alpha_code) like UPPER(?)";
                result = pool.selectPrestatement(query, three_alpha_code);
                if (result.next()) {
                    record = new FigisRecord(result);
                }
            }
            catch (Throwable e) {
                log.error("general Error", e);
                if (pool != null && con != null) {
                    pool.releaseConnection(con);
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException ex) {
                    log.error("sql Error", (Throwable)ex);
                }
            }
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (SQLException ex) {
                log.error("sql Error", (Throwable)ex);
            }
        }
        return record;
    }

    public boolean createTabUpdates() throws SQLException {
        log.info("Creating table figis... ");
        ConnectionPool pool = null;
        Connection con = null;
        try {
            try {
                pool = ConnectionPool.getConnectionPool();
                con = pool.getConnection();
                String query = "create table updates (id serial NOT NULL PRIMARY KEY, date date)";
                boolean result = pool.insertPreStatement(query);
                if (!result) {
                    log.error("problem creating table");
                }
            }
            catch (ConnectionPoolException e) {
                log.error("ConnectionPoolException", (Throwable)e);
                if (pool != null && con != null) {
                    pool.releaseConnection(con);
                }
            }
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
        return true;
    }
}

