/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import opendap.dap.BaseType;
import opendap.dap.ClientIO;
import opendap.dap.Int16PrimitiveVector;
import opendap.dap.PrimitiveVector;
import opendap.dap.ServerVersion;
import opendap.dap.StatusUI;

public class DInt16
extends BaseType
implements ClientIO {
    private short val;

    public DInt16() {
    }

    public DInt16(String n) {
        super(n);
    }

    public final short getValue() {
        return this.val;
    }

    public final void setValue(short newVal) {
        this.val = newVal;
    }

    @Override
    public PrimitiveVector newPrimitiveVector() {
        return new Int16PrimitiveVector(this);
    }

    @Override
    public String getTypeName() {
        return "Int16";
    }

    @Override
    public void printVal(PrintWriter os, String space, boolean print_decl_p) {
        if (print_decl_p) {
            this.printDecl(os, space, false);
            os.println(" = " + this.val + ";");
        } else {
            os.print(this.val);
        }
    }

    @Override
    public synchronized void deserialize(DataInputStream source, ServerVersion sv, StatusUI statusUI) throws IOException, EOFException {
        this.val = (short)source.readInt();
        if (statusUI != null) {
            statusUI.incrementByteCount(4);
        }
    }

    @Override
    public void externalize(DataOutputStream sink) throws IOException {
        sink.writeInt(this.val);
    }
}

