/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;

public class IOUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyBytes(InputStream in, OutputStream out, int buffSize, boolean close) throws IOException {
        PrintStream ps = out instanceof PrintStream ? (PrintStream)out : null;
        byte[] buf = new byte[buffSize];
        try {
            int bytesRead = in.read(buf);
            while (bytesRead >= 0) {
                out.write(buf, 0, bytesRead);
                if (ps != null && ps.checkError()) {
                    throw new IOException("Unable to write to output stream.");
                }
                bytesRead = in.read(buf);
            }
        }
        finally {
            if (close) {
                out.close();
                in.close();
            }
        }
    }

    public static void copyBytes(InputStream in, OutputStream out, Configuration conf) throws IOException {
        IOUtils.copyBytes(in, out, conf.getInt("io.file.buffer.size", 4096), true);
    }

    public static void copyBytes(InputStream in, OutputStream out, Configuration conf, boolean close) throws IOException {
        IOUtils.copyBytes(in, out, conf.getInt("io.file.buffer.size", 4096), close);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyBytes(InputStream in, OutputStream out, long count, boolean close) throws IOException {
        byte[] buf = new byte[4096];
        try {
            int bytesRead;
            for (long bytesRemaining = count; bytesRemaining > 0L; bytesRemaining -= (long)bytesRead) {
                int bytesToRead = (int)(bytesRemaining < (long)buf.length ? bytesRemaining : (long)buf.length);
                bytesRead = in.read(buf, 0, bytesToRead);
                if (bytesRead == -1) {
                    break;
                }
                out.write(buf, 0, bytesRead);
            }
        }
        finally {
            if (close) {
                out.close();
                in.close();
            }
        }
    }

    public static void readFully(InputStream in, byte[] buf, int off, int len) throws IOException {
        int toRead = len;
        while (toRead > 0) {
            int ret = in.read(buf, off, toRead);
            if (ret < 0) {
                throw new IOException("Premature EOF from inputStream");
            }
            toRead -= ret;
            off += ret;
        }
    }

    public static void readFileChannelFully(FileChannel fileChannel, byte[] buf, int off, int len) throws IOException {
        int toRead = len;
        ByteBuffer byteBuffer = ByteBuffer.wrap(buf, off, len);
        while (toRead > 0) {
            int ret = fileChannel.read(byteBuffer);
            if (ret < 0) {
                throw new IOException("Premature EOF from inputStream");
            }
            toRead -= ret;
            off += ret;
        }
    }

    public static void skipFully(InputStream in, long len) throws IOException {
        while (len > 0L) {
            long ret = in.skip(len);
            if (ret < 0L) {
                throw new IOException("Premeture EOF from inputStream");
            }
            len -= ret;
        }
    }

    public static void cleanup(Log log, Closeable ... closeables) {
        for (Closeable c : closeables) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (IOException e) {
                if (log == null || !log.isDebugEnabled()) continue;
                log.debug((Object)("Exception in closing " + c), (Throwable)e);
            }
        }
    }

    public static void closeStream(Closeable stream) {
        IOUtils.cleanup(null, stream);
    }

    public static void closeSocket(Socket sock) {
        if (sock != null) {
            try {
                sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class NullOutputStream
    extends OutputStream {
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }
}

