/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.wps_hadoop.streaming;

import com.terradue.wps_hadoop.streaming.ExecutionResultsInfo;
import com.terradue.wps_hadoop.streaming.WpsHadoopConfiguration;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.n52.wps.io.data.GenericFileData;
import org.n52.wps.io.data.binding.complex.GenericFileDataBinding;

public class ResultsInfo {
    private static Logger LOGGER = Logger.getLogger(ResultsInfo.class);
    private WpsHadoopConfiguration configuration;
    private String jobId;
    private String algorithmName;
    private String errorMessage;
    private List<ExecutionResultsInfo> executionsResultsList = new ArrayList<ExecutionResultsInfo>();

    public ResultsInfo(WpsHadoopConfiguration configuration, String jobId, String algorithmName) {
        this.configuration = configuration;
        this.jobId = jobId;
        this.algorithmName = algorithmName;
    }

    public void setErrorMessage(String msg) {
        this.errorMessage = msg;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public static void main(String[] args) {
        WpsHadoopConfiguration conf = new WpsHadoopConfiguration();
        ResultsInfo result = new ResultsInfo(conf, "c9e2c5d7-faaa-44bc-9a6a-06447b110b81", "my algorithm");
    }

    public void addExecutionResults(ExecutionResultsInfo executionResults) {
        this.executionsResultsList.add(executionResults);
    }

    public String getText(boolean withTitles) {
        StringBuilder sb = new StringBuilder();
        if (withTitles) {
            sb.append("AlgorithmName: ").append(this.algorithmName).append("\n");
            sb.append("JobId: ").append(this.jobId).append("\n");
        }
        for (ExecutionResultsInfo executionResults : this.executionsResultsList) {
            sb.append("\n");
            if (executionResults.getInputDataUrl() != null) {
                if (withTitles) {
                    sb.append("InputData: ");
                }
                sb.append(executionResults.getInputDataUrl()).append("\n");
            }
            for (String url : executionResults.getOutputUrls()) {
                if (withTitles) {
                    sb.append("OutputData: ");
                }
                sb.append(url).append("\n");
            }
        }
        return sb.toString();
    }

    public GenericFileDataBinding getXmlFileDataBinding() {
        String xml = this.getXml();
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
        return new GenericFileDataBinding(new GenericFileData((InputStream)is, "text/plain"));
    }

    public String getXml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<streamingOutput>\n");
        sb.append("\t<algorithmName>").append(this.algorithmName).append("</algorithmName>\n");
        sb.append("\t<jobId>").append(this.jobId).append("</jobId>\n");
        for (ExecutionResultsInfo executionResults : this.executionsResultsList) {
            sb.append("\t<executionResult>\n");
            if (executionResults.getInputDataUrl() != null) {
                sb.append("\t\t<inputData>\n");
                sb.append("\t\t\t<url>").append(executionResults.getInputDataUrl()).append("</url>\n");
                sb.append("\t\t</inputData>\n");
            }
            sb.append("\t\t<outputData>\n");
            for (String url : executionResults.getOutputUrls()) {
                sb.append("\t\t\t<url>").append(url).append("</url>\n");
            }
            sb.append("\t\t</outputData>\n");
            sb.append("\t</executionResult>\n");
        }
        sb.append("</streamingOutput>\n");
        return sb.toString();
    }
}

