/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.wps_hadoop.processes.terradue.envi_enrich;

import com.terradue.wps_hadoop.common.input.InputUtils;
import com.terradue.wps_hadoop.common.input.ListInputResource;
import com.terradue.wps_hadoop.streaming.ResultsInfo;
import com.terradue.wps_hadoop.streaming.StreamingPackagedAlgorithm;
import com.terradue.wps_hadoop.streaming.WpsHadoopConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.complex.GenericFileDataBinding;
import org.n52.wps.io.data.binding.literal.LiteralStringBinding;
import org.n52.wps.server.AbstractAlgorithm;

public class EnviEnrich
extends AbstractAlgorithm {
    protected final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    private List<String> errors = new ArrayList<String>();
    private static String[] acceptedEnvVars = new String[]{"calcite", "chlo", "cloud", "da", "dissox", "nitrate", "par", "ph", "phosphate", "salinity", "silicate", "sst"};
    private static String[] defaultEnvVarsSet = new String[]{"salinity", "sst"};

    public Map<String, IData> run(Map<String, List<IData>> inputData) {
        List<String> species = InputUtils.getListStringInputParameter(inputData, "species", true);
        List<String> envVars = InputUtils.getListStringInputParameter(inputData, "envVars");
        Integer windowSize = InputUtils.getIntegerInputParameter(inputData, "windowSize", 1);
        envVars = this.validateAndProcessEnvVars(envVars);
        String envVarsParam = this.getEnvVarsListParameter(envVars);
        String fromDate = InputUtils.getStringInputParameter(inputData, "fromDate");
        String toDate = InputUtils.getStringInputParameter(inputData, "toDate");
        if (windowSize != 1 && windowSize != 3 && windowSize != 5) {
            throw new RuntimeException("Parameter windowSize must be 1, 3 or 5");
        }
        this.logger.info((Object)"Running Job ENVIRONMENT ENRICHMENT...");
        WpsHadoopConfiguration conf = new WpsHadoopConfiguration();
        StreamingPackagedAlgorithm streaming = new StreamingPackagedAlgorithm(conf);
        streaming.setAlgorithmName("envi_enrich");
        streaming.setInputResource(new ListInputResource(species));
        if (fromDate != null) {
            streaming.addFixedParameter("fromDate", fromDate);
        }
        if (toDate != null) {
            streaming.addFixedParameter("toDate", toDate);
        }
        streaming.addFixedParameter("windowSize", windowSize);
        streaming.addFixedParameter("envVars", envVarsParam);
        streaming.setDebugMode(true);
        try {
            ResultsInfo result = streaming.runSync();
            HashMap<String, IData> wpsResultMap = new HashMap<String, IData>();
            wpsResultMap.put("result", (IData)result.getXmlFileDataBinding());
            return wpsResultMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Execution job failed! " + e.getMessage());
        }
    }

    private List<String> validateAndProcessEnvVars(List<String> envVars) {
        if (envVars == null || envVars.size() == 0) {
            return new ArrayList<String>(Arrays.asList(defaultEnvVarsSet));
        }
        ArrayList<String> acceptedEnvVarsList = new ArrayList<String>(Arrays.asList(acceptedEnvVars));
        ArrayList<String> processedEnvVars = new ArrayList<String>();
        for (String envVar : envVars) {
            String lcEnvVar = envVar.toLowerCase();
            if (!acceptedEnvVarsList.contains(lcEnvVar)) {
                throw new RuntimeException("Invalid Environment Variable: " + envVar);
            }
            if (processedEnvVars.contains(lcEnvVar)) continue;
            processedEnvVars.add(lcEnvVar);
        }
        return processedEnvVars;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public Class<?> getInputDataType(String id) {
        return LiteralStringBinding.class;
    }

    public Class<?> getOutputDataType(String id) {
        if (id.contentEquals("result")) {
            return GenericFileDataBinding.class;
        }
        return null;
    }

    private String getEnvVarsListParameter(List<String> envVars) {
        if (envVars == null || envVars.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String envVar : envVars) {
            sb.append((i++ == 0 ? "" : ";") + envVar);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
    }
}

