/*
 * Decompiled with CFR 0.152.
 */
package org.expressme.openid;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ShortName {
    private Map<String, String> urlMap = new HashMap<String, String>();
    private Map<String, String> aliasMap = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShortName() {
        InputStream input = null;
        try {
            input = this.getClass().getClassLoader().getResourceAsStream("openid-providers.properties");
            Properties props = new Properties();
            props.load(input);
            for (Object k : props.keySet()) {
                String key = (String)k;
                String value = props.getProperty(key);
                if (key.endsWith(".alias")) {
                    this.aliasMap.put(key.substring(0, key.length() - 6), value);
                    continue;
                }
                this.urlMap.put(key, value);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    String lookupUrlByName(String name) {
        return this.urlMap.get(name);
    }

    String lookupAliasByName(String name) {
        String alias = this.aliasMap.get(name);
        return alias == null ? "ext1" : alias;
    }
}

