/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.jcatalogue.client;

import com.terradue.jcatalogue.client.CatalogueClient;
import com.terradue.jcatalogue.client.Parameter;
import com.terradue.jcatalogue.client.Series;
import java.beans.ConstructorProperties;
import java.util.Iterator;

final class LazyLoadSerieIterator
implements Iterator<Series> {
    private final CatalogueClient catalogueClient;
    private final Iterator<String> serieUrlsIterator;

    @Override
    public boolean hasNext() {
        return this.serieUrlsIterator.hasNext();
    }

    @Override
    public Series next() {
        String nextUrl = this.serieUrlsIterator.next();
        return this.catalogueClient.getSeries(nextUrl, new Parameter[0]);
    }

    @Override
    public void remove() {
    }

    @ConstructorProperties(value={"catalogueClient", "serieUrlsIterator"})
    public LazyLoadSerieIterator(CatalogueClient catalogueClient, Iterator<String> serieUrlsIterator) {
        this.catalogueClient = catalogueClient;
        this.serieUrlsIterator = serieUrlsIterator;
    }

    public CatalogueClient getCatalogueClient() {
        return this.catalogueClient;
    }

    public Iterator<String> getSerieUrlsIterator() {
        return this.serieUrlsIterator;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LazyLoadSerieIterator)) {
            return false;
        }
        LazyLoadSerieIterator other = (LazyLoadSerieIterator)o;
        if (this.getCatalogueClient() == null ? other.getCatalogueClient() != null : !this.getCatalogueClient().equals(other.getCatalogueClient())) {
            return false;
        }
        return !(this.getSerieUrlsIterator() == null ? other.getSerieUrlsIterator() != null : !this.getSerieUrlsIterator().equals(other.getSerieUrlsIterator()));
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = result * 31 + (this.getCatalogueClient() == null ? 0 : this.getCatalogueClient().hashCode());
        result = result * 31 + (this.getSerieUrlsIterator() == null ? 0 : this.getSerieUrlsIterator().hashCode());
        return result;
    }

    public String toString() {
        return "LazyLoadSerieIterator(catalogueClient=" + this.getCatalogueClient() + ", serieUrlsIterator=" + this.getSerieUrlsIterator() + ")";
    }
}

