/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.typedbytes;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.typedbytes.Type;
import org.apache.hadoop.typedbytes.TypedBytesInput;
import org.apache.hadoop.typedbytes.TypedBytesOutput;

public class TypedBytesWritable
extends BytesWritable {
    public TypedBytesWritable() {
    }

    public TypedBytesWritable(byte[] bytes) {
        super(bytes);
    }

    public void setValue(Object obj) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            TypedBytesOutput tbo = TypedBytesOutput.get(new DataOutputStream(baos));
            tbo.write(obj);
            byte[] bytes = baos.toByteArray();
            this.set(bytes, 0, bytes.length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Object getValue() {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.getBytes());
            TypedBytesInput tbi = TypedBytesInput.get(new DataInputStream(bais));
            Object obj = tbi.read();
            return obj;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Type getType() {
        byte[] bytes = this.getBytes();
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        for (Type type : Type.values()) {
            if (type.code != bytes[0]) continue;
            return type;
        }
        return null;
    }

    public String toString() {
        return this.getValue().toString();
    }
}

