/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.wps_hadoop.processes.examples.bathymetry;

import com.terradue.wps_hadoop.common.VTIBathymetry;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;

public class BathymetryMapper
extends MapReduceBase
implements Mapper<LongWritable, Text, LongWritable, Text> {
    String fileName = "";

    public void configure(JobConf job) {
        this.fileName = job.get("inputFile");
    }

    public void map(LongWritable key, Text value, OutputCollector<LongWritable, Text> output, Reporter reporter) throws IOException {
        VTIBathymetry bm = new VTIBathymetry(this.fileName);
        bm.debug = false;
        String line = value.toString();
        StringTokenizer tokenizer = new StringTokenizer(line);
        while (tokenizer.hasMoreTokens()) {
            Double x = Double.parseDouble(tokenizer.nextToken());
            Double y = Double.parseDouble(tokenizer.nextToken());
            String coordinates = "" + x.intValue() + "," + y.intValue();
            Short res = bm.get(x, y);
            coordinates = coordinates + "," + res;
            output.collect((Object)key, (Object)new Text(coordinates));
        }
    }
}

