/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.jcatalogue.client.internal.ahc;

import com.ning.http.client.Cookie;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.filter.FilterContext;
import com.ning.http.client.filter.FilterException;
import com.ning.http.client.filter.ResponseFilter;
import com.ning.http.util.AsyncHttpProviderUtils;
import com.terradue.jcatalogue.client.HttpMethod;
import com.terradue.jcatalogue.client.Parameter;
import com.terradue.jcatalogue.client.internal.ahc.UmSsoAccess;
import com.terradue.jcatalogue.client.internal.lang.Assertions;
import java.net.URI;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class UmSsoStatusResponseFilter
implements ResponseFilter {
    private static final String SET_COOKIE = "Set-Cookie";
    private static final String CONTENT_TYPE = "Content-Type";
    private final Pattern textHtmlPattern = Pattern.compile("text/html", 2);
    private final BitSet admittedStatuses = new BitSet();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, UmSsoAccess> umSsoCredentials;
    private final ConcurrentMap<String, ConcurrentMap<String, Cookie>> cookiesRegistry;

    public UmSsoStatusResponseFilter(ConcurrentMap<String, UmSsoAccess> umSsoCredentials, ConcurrentMap<String, ConcurrentMap<String, Cookie>> cookiesRegistry) {
        this.umSsoCredentials = umSsoCredentials;
        this.cookiesRegistry = cookiesRegistry;
        this.admittedStatuses.set(200);
        this.admittedStatuses.set(301);
        this.admittedStatuses.set(302);
        this.admittedStatuses.set(307);
    }

    public FilterContext filter(FilterContext ctx) throws FilterException {
        HttpResponseStatus responseStatus = ctx.getResponseStatus();
        Assertions.checkState(this.admittedStatuses.get(responseStatus.getStatusCode()), "Impossible to query the catalog %s, server replied %s", ctx.getRequest().getRawUrl(), responseStatus.getStatusText());
        String currentDomain = URI.create(ctx.getRequest().getUrl()).getHost();
        List cookiesString = ctx.getResponseHeaders().getHeaders().get((Object)SET_COOKIE);
        LinkedList<Cookie> cookies = new LinkedList<Cookie>();
        if (cookiesString == null || cookiesString.isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("No cookies to manage in domain {}", (Object)currentDomain);
            }
        } else {
            ConcurrentHashMap<String, Cookie> domainCookies = (ConcurrentHashMap<String, Cookie>)this.cookiesRegistry.get(currentDomain);
            if (domainCookies == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Domain {} was not already managed", (Object)currentDomain);
                }
                domainCookies = new ConcurrentHashMap<String, Cookie>();
                this.cookiesRegistry.put(currentDomain, domainCookies);
            }
            for (String cookieValue : cookiesString) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Received cookie {}", (Object)cookieValue);
                }
                Cookie currentCookie = AsyncHttpProviderUtils.parseCookie((String)cookieValue);
                cookies.add(currentCookie);
                domainCookies.put(currentCookie.getName(), currentCookie);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Checking server status code reply: {}", (Object)responseStatus.getStatusCode());
        }
        if (200 == responseStatus.getStatusCode()) {
            UmSsoAccess umSsoAccess;
            String contentType = ctx.getResponseHeaders().getHeaders().getFirstValue(CONTENT_TYPE);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Checking content type {} behavior", (Object)contentType);
            }
            if (!this.textHtmlPattern.matcher(contentType).matches()) {
                this.logger.debug("Content type {} doesn't ned to be analyzed, just proceed", (Object)contentType);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Checking UM-SSO auth credentials for current host {}", (Object)currentDomain);
            }
            if ((umSsoAccess = this.umSsoCredentials.get(currentDomain)) != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Redirecting request to {} {}", (Object)umSsoAccess.getHttpMethod(), (Object)umSsoAccess.getLoginFormUrl());
                }
                RequestBuilder authRequestBuilder = new RequestBuilder(umSsoAccess.getHttpMethod().toString()).setUrl(umSsoAccess.getLoginFormUrl().toString());
                for (Cookie cookie : ((ConcurrentMap)this.cookiesRegistry.get(currentDomain)).values()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Adding {} for host {}", (Object)cookie, (Object)currentDomain);
                    }
                    authRequestBuilder.addCookie(cookie);
                }
                for (Parameter parameter : umSsoAccess.getParameters()) {
                    authRequestBuilder.addParameter(parameter.getName(), parameter.getValue());
                }
                return new FilterContext.FilterContextBuilder(ctx).request(authRequestBuilder.build()).asyncHandler(ctx.getAsyncHandler()).replayRequest(true).build();
            }
            return ctx;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Proceeding on serving the request");
        }
        if (HttpMethod.POST.toString().equals(ctx.getRequest().getMethod())) {
            RequestBuilder redirect = new RequestBuilder(ctx.getRequest()).setMethod(HttpMethod.GET.toString());
            for (Cookie cookie : cookies) {
                redirect.addOrReplaceCookie(cookie);
            }
            return new FilterContext.FilterContextBuilder(ctx).request(redirect.build()).replayRequest(true).build();
        }
        return ctx;
    }
}

