/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.jcatalogue.client.download;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.terradue.jcatalogue.client.download.DownloadHandler;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

final class HttpDownloadHandler<T>
implements AsyncHandler<T> {
    private static final String CONTENT_LENGTH = "Content-Length";
    private final File targetFile;
    private final FileOutputStream output;
    private final DownloadHandler<T> downloadHandler;
    private long contentLength = -1L;
    private long downloadCounter = 0L;

    public HttpDownloadHandler(File targetFile, DownloadHandler<T> downloadHandler) throws FileNotFoundException {
        this.targetFile = targetFile;
        this.output = new FileOutputStream(targetFile);
        this.downloadHandler = downloadHandler;
    }

    public void onThrowable(Throwable t) {
        this.downloadHandler.onError(t);
    }

    public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
        bodyPart.writeTo((OutputStream)this.output);
        if (this.contentLength > 0L) {
            this.downloadCounter += (long)bodyPart.getBodyPartBytes().length;
            this.downloadHandler.onContentDownloadProgress(this.downloadCounter, this.contentLength);
        }
        return AsyncHandler.STATE.CONTINUE;
    }

    public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
        return AsyncHandler.STATE.CONTINUE;
    }

    public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        List contentLength = headers.getHeaders().get((Object)CONTENT_LENGTH);
        if (!contentLength.isEmpty()) {
            this.contentLength = Long.valueOf((String)contentLength.iterator().next());
        }
        return AsyncHandler.STATE.CONTINUE;
    }

    public T onCompleted() throws Exception {
        this.output.flush();
        HttpDownloadHandler.closeQuietly(this.output);
        return this.downloadHandler.onCompleted(this.targetFile);
    }

    private static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

