/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.EagerTaskInitializationListener;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobQueueJobInProgressListener;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskScheduler;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.mapreduce.server.jobtracker.TaskTracker;

class JobQueueTaskScheduler
extends TaskScheduler {
    private static final int MIN_CLUSTER_SIZE_FOR_PADDING = 3;
    public static final Log LOG = LogFactory.getLog(JobQueueTaskScheduler.class);
    protected JobQueueJobInProgressListener jobQueueJobInProgressListener = new JobQueueJobInProgressListener();
    protected EagerTaskInitializationListener eagerTaskInitializationListener;
    private float padFraction;

    @Override
    public synchronized void start() throws IOException {
        super.start();
        this.taskTrackerManager.addJobInProgressListener(this.jobQueueJobInProgressListener);
        this.eagerTaskInitializationListener.setTaskTrackerManager(this.taskTrackerManager);
        this.eagerTaskInitializationListener.start();
        this.taskTrackerManager.addJobInProgressListener(this.eagerTaskInitializationListener);
    }

    @Override
    public synchronized void terminate() throws IOException {
        if (this.jobQueueJobInProgressListener != null) {
            this.taskTrackerManager.removeJobInProgressListener(this.jobQueueJobInProgressListener);
        }
        if (this.eagerTaskInitializationListener != null) {
            this.taskTrackerManager.removeJobInProgressListener(this.eagerTaskInitializationListener);
            this.eagerTaskInitializationListener.terminate();
        }
        super.terminate();
    }

    @Override
    public synchronized void setConf(Configuration conf) {
        super.setConf(conf);
        this.padFraction = conf.getFloat("mapred.jobtracker.taskalloc.capacitypad", 0.01f);
        this.eagerTaskInitializationListener = new EagerTaskInitializationListener(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List<Task> assignTasks(TaskTracker taskTracker) throws IOException {
        TaskTrackerStatus taskTrackerStatus = taskTracker.getStatus();
        ClusterStatus clusterStatus = this.taskTrackerManager.getClusterStatus();
        int numTaskTrackers = clusterStatus.getTaskTrackers();
        int clusterMapCapacity = clusterStatus.getMaxMapTasks();
        int clusterReduceCapacity = clusterStatus.getMaxReduceTasks();
        Collection<JobInProgress> jobQueue = this.jobQueueJobInProgressListener.getJobQueue();
        int trackerMapCapacity = taskTrackerStatus.getMaxMapSlots();
        int trackerReduceCapacity = taskTrackerStatus.getMaxReduceSlots();
        int trackerRunningMaps = taskTrackerStatus.countMapTasks();
        int trackerRunningReduces = taskTrackerStatus.countReduceTasks();
        ArrayList<Task> assignedTasks = new ArrayList<Task>();
        int remainingReduceLoad = 0;
        int remainingMapLoad = 0;
        Collection<JobInProgress> collection = jobQueue;
        synchronized (collection) {
            for (JobInProgress job : jobQueue) {
                if (job.getStatus().getRunState() != 1) continue;
                remainingMapLoad += job.desiredMaps() - job.finishedMaps();
                if (!job.scheduleReduces()) continue;
                remainingReduceLoad += job.desiredReduces() - job.finishedReduces();
            }
        }
        double mapLoadFactor = 0.0;
        if (clusterMapCapacity > 0) {
            mapLoadFactor = (double)remainingMapLoad / (double)clusterMapCapacity;
        }
        double reduceLoadFactor = 0.0;
        if (clusterReduceCapacity > 0) {
            reduceLoadFactor = (double)remainingReduceLoad / (double)clusterReduceCapacity;
        }
        int trackerCurrentMapCapacity = Math.min((int)Math.ceil(mapLoadFactor * (double)trackerMapCapacity), trackerMapCapacity);
        int availableMapSlots = trackerCurrentMapCapacity - trackerRunningMaps;
        boolean exceededMapPadding = false;
        if (availableMapSlots > 0) {
            exceededMapPadding = this.exceededPadding(true, clusterStatus, trackerMapCapacity);
        }
        int numLocalMaps = 0;
        int numNonLocalMaps = 0;
        block10: for (int i = 0; i < availableMapSlots; ++i) {
            Collection<JobInProgress> collection2 = jobQueue;
            synchronized (collection2) {
                for (JobInProgress job : jobQueue) {
                    if (job.getStatus().getRunState() != 1) continue;
                    Task t = null;
                    t = job.obtainNewLocalMapTask(taskTrackerStatus, numTaskTrackers, this.taskTrackerManager.getNumberOfUniqueHosts());
                    if (t != null) {
                        assignedTasks.add(t);
                        ++numLocalMaps;
                        if (!exceededMapPadding) break;
                        break block10;
                    }
                    t = job.obtainNewNonLocalMapTask(taskTrackerStatus, numTaskTrackers, this.taskTrackerManager.getNumberOfUniqueHosts());
                    if (t == null) continue;
                    assignedTasks.add(t);
                    ++numNonLocalMaps;
                    break block10;
                }
                continue;
            }
        }
        int assignedMaps = assignedTasks.size();
        int trackerCurrentReduceCapacity = Math.min((int)Math.ceil(reduceLoadFactor * (double)trackerReduceCapacity), trackerReduceCapacity);
        int availableReduceSlots = Math.min(trackerCurrentReduceCapacity - trackerRunningReduces, 1);
        boolean exceededReducePadding = false;
        if (availableReduceSlots > 0) {
            exceededReducePadding = this.exceededPadding(false, clusterStatus, trackerReduceCapacity);
            Collection<JobInProgress> collection3 = jobQueue;
            synchronized (collection3) {
                for (JobInProgress job : jobQueue) {
                    if (job.getStatus().getRunState() != 1 || job.numReduceTasks == 0) continue;
                    Task t = job.obtainNewReduceTask(taskTrackerStatus, numTaskTrackers, this.taskTrackerManager.getNumberOfUniqueHosts());
                    if (t != null) {
                        assignedTasks.add(t);
                        break;
                    }
                    if (!exceededReducePadding) continue;
                    break;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Task assignments for " + taskTrackerStatus.getTrackerName() + " --> " + "[" + mapLoadFactor + ", " + trackerMapCapacity + ", " + trackerCurrentMapCapacity + ", " + trackerRunningMaps + "] -> [" + (trackerCurrentMapCapacity - trackerRunningMaps) + ", " + assignedMaps + " (" + numLocalMaps + ", " + numNonLocalMaps + ")] [" + reduceLoadFactor + ", " + trackerReduceCapacity + ", " + trackerCurrentReduceCapacity + "," + trackerRunningReduces + "] -> [" + (trackerCurrentReduceCapacity - trackerRunningReduces) + ", " + (assignedTasks.size() - assignedMaps) + "]"));
        }
        return assignedTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exceededPadding(boolean isMapTask, ClusterStatus clusterStatus, int maxTaskTrackerSlots) {
        int numTaskTrackers = clusterStatus.getTaskTrackers();
        int totalTasks = isMapTask ? clusterStatus.getMapTasks() : clusterStatus.getReduceTasks();
        int totalTaskCapacity = isMapTask ? clusterStatus.getMaxMapTasks() : clusterStatus.getMaxReduceTasks();
        Collection<JobInProgress> jobQueue = this.jobQueueJobInProgressListener.getJobQueue();
        boolean exceededPadding = false;
        Collection<JobInProgress> collection = jobQueue;
        synchronized (collection) {
            int totalNeededTasks = 0;
            for (JobInProgress job : jobQueue) {
                if (job.getStatus().getRunState() != 1 || job.numReduceTasks == 0) continue;
                totalNeededTasks += isMapTask ? job.desiredMaps() : job.desiredReduces();
                int padding = 0;
                if (numTaskTrackers > 3) {
                    padding = Math.min(maxTaskTrackerSlots, (int)((float)totalNeededTasks * this.padFraction));
                }
                if (totalTasks + padding < totalTaskCapacity) continue;
                exceededPadding = true;
                break;
            }
        }
        return exceededPadding;
    }

    @Override
    public synchronized Collection<JobInProgress> getJobs(String queueName) {
        return this.jobQueueJobInProgressListener.getJobQueue();
    }
}

