/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.SkipPageException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.namenode.JspHelper;
import org.apache.hadoop.http.HtmlQuoting;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ServletUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspSourceDependent;
import org.apache.jasper.runtime.ResourceInjector;

public final class browseDirectory_jsp
extends HttpJspBase
implements JspSourceDependent {
    static JspHelper jspHelper = new JspHelper();
    private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();
    private static Vector _jspx_dependants;
    private ResourceInjector _jspx_resourceInjector;

    public void generateDirectoryStructure(JspWriter out, HttpServletRequest req, HttpServletResponse resp, Configuration conf) throws IOException, InterruptedException {
        String target;
        DFSClient dfs;
        String dir = HtmlQuoting.unquoteHtmlChars(req.getParameter("dir"));
        if (dir == null || dir.length() == 0) {
            out.print("Invalid input");
            return;
        }
        String tokenString = req.getParameter("delegation");
        UserGroupInformation ugi = JspHelper.getUGI(req, conf);
        String namenodeInfoPortStr = req.getParameter("namenodeInfoPort");
        int namenodeInfoPort = -1;
        if (namenodeInfoPortStr != null) {
            namenodeInfoPort = Integer.parseInt(namenodeInfoPortStr);
        }
        if (!(dfs = JspHelper.getDFSClient(ugi, JspHelper.nameNodeAddr, conf)).exists(target = dir)) {
            out.print("<h3>File or directory : " + target + " does not exist</h3>");
            JspHelper.printGotoForm(out, namenodeInfoPort, tokenString, HtmlQuoting.quoteHtmlChars(target));
        } else {
            DirectoryListing thisListing;
            if (!dfs.isDirectory(target)) {
                List<LocatedBlock> blocks = dfs.namenode.getBlockLocations(dir, 0L, 1L).getLocatedBlocks();
                LocatedBlock firstBlock = null;
                DatanodeInfo[] locations = null;
                if (blocks.size() > 0) {
                    firstBlock = blocks.get(0);
                    locations = firstBlock.getLocations();
                }
                if (locations == null || locations.length == 0) {
                    out.print("Empty file");
                } else {
                    DatanodeInfo chosenNode = jspHelper.bestNode(firstBlock);
                    String fqdn = InetAddress.getByName(chosenNode.getHost()).getCanonicalHostName();
                    String datanodeAddr = chosenNode.getName();
                    int datanodePort = Integer.parseInt(datanodeAddr.substring(datanodeAddr.indexOf(58) + 1, datanodeAddr.length()));
                    String redirectLocation = "http://" + fqdn + ":" + chosenNode.getInfoPort() + "/browseBlock.jsp?blockId=" + firstBlock.getBlock().getBlockId() + "&blockSize=" + firstBlock.getBlock().getNumBytes() + "&genstamp=" + firstBlock.getBlock().getGenerationStamp() + "&filename=" + URLEncoder.encode(dir, "UTF-8") + "&datanodePort=" + datanodePort + "&namenodeInfoPort=" + namenodeInfoPort + JspHelper.getDelegationTokenUrlParam(tokenString);
                    resp.sendRedirect(redirectLocation);
                }
                return;
            }
            String[] headings = new String[]{"Name", "Type", "Size", "Replication", "Block Size", "Modification Time", "Permission", "Owner", "Group"};
            out.print("<h3>Contents of directory ");
            JspHelper.printPathWithLinks(HtmlQuoting.quoteHtmlChars(dir), out, namenodeInfoPort, tokenString);
            out.print("</h3><hr>");
            JspHelper.printGotoForm(out, namenodeInfoPort, tokenString, HtmlQuoting.quoteHtmlChars(dir));
            out.print("<hr>");
            File f = new File(dir);
            String parent = f.getParent();
            if (parent != null) {
                out.print("<a href=\"" + req.getRequestURL() + "?dir=" + URLEncoder.encode(parent, "UTF-8") + "&namenodeInfoPort=" + namenodeInfoPort + JspHelper.getDelegationTokenUrlParam(tokenString) + "\">Go to parent directory</a><br>");
            }
            if ((thisListing = dfs.listPaths(target, HdfsFileStatus.EMPTY_NAME)) == null || thisListing.getPartialListing().length == 0) {
                out.print("Empty directory");
            } else {
                jspHelper.addTableHeader(out);
                out.print("<thead>\n");
                jspHelper.addTableHeadingRow(out, headings);
                out.print("</thead><tbody>\n");
                String[] cols = new String[headings.length];
                do {
                    HdfsFileStatus[] files = thisListing.getPartialListing();
                    for (int i = 0; i < files.length; ++i) {
                        String localname = files[i].getLocalName();
                        if (localname.endsWith(".crc")) continue;
                        if (!files[i].isDir()) {
                            cols[1] = "file";
                            cols[2] = StringUtils.byteDesc(files[i].getLen());
                            cols[3] = Short.toString(files[i].getReplication());
                            cols[4] = StringUtils.byteDesc(files[i].getBlockSize());
                        } else {
                            cols[1] = "dir";
                            cols[2] = "";
                            cols[3] = "";
                            cols[4] = "";
                        }
                        String datanodeUrl = req.getRequestURL() + "?dir=" + URLEncoder.encode(files[i].getFullName(target), "UTF-8") + "&namenodeInfoPort=" + namenodeInfoPort + JspHelper.getDelegationTokenUrlParam(tokenString);
                        cols[0] = "<a href=\"" + datanodeUrl + "\">" + localname + "</a>";
                        cols[5] = FsShell.dateForm.format(new Date(files[i].getModificationTime()));
                        cols[6] = files[i].getPermission().toString();
                        cols[7] = files[i].getOwner();
                        cols[8] = files[i].getGroup();
                        jspHelper.addTableRow(out, cols);
                    }
                    if (thisListing.hasMore()) continue;
                    out.print("</tbody>\n");
                    break;
                } while ((thisListing = dfs.listPaths(target, thisListing.getLastName())) != null);
                jspHelper.addTableFooter(out);
            }
        }
        String namenodeHost = JspHelper.nameNodeAddr.getHostName();
        out.print("<br><a href=\"http://" + InetAddress.getByName(namenodeHost).getCanonicalHostName() + ":" + namenodeInfoPort + "/dfshealth.jsp\">Go back to DFS home</a>");
        dfs.close();
    }

    public Object getDependants() {
        return _jspx_dependants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        PageContext pageContext = null;
        HttpSession session = null;
        ServletContext application = null;
        ServletConfig config = null;
        JspWriter out = null;
        browseDirectory_jsp page = this;
        JspWriter _jspx_out = null;
        PageContext _jspx_page_context = null;
        try {
            response.setContentType("text/html; charset=UTF-8");
            _jspx_page_context = pageContext = _jspxFactory.getPageContext((Servlet)this, (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
            application = pageContext.getServletContext();
            config = pageContext.getServletConfig();
            session = pageContext.getSession();
            _jspx_out = out = pageContext.getOut();
            this._jspx_resourceInjector = (ResourceInjector)application.getAttribute("com.sun.appserv.jsp.resource.injector");
            out.write(10);
            out.write("\n\n<html>\n<head>\n<link rel=\"stylesheet\" type=\"text/css\" href=\"/static/hadoop.css\">\n<link rel=\"icon\" type=\"image/vnd.microsoft.icon\" href=\"/static/images/favicon.ico\" />\n");
            JspHelper.createTitle(out, request, request.getParameter("dir"));
            out.write("\n</head>\n\n<body onload=\"document.goto.dir.focus()\">\n");
            Configuration conf = (Configuration)this.getServletContext().getAttribute("current.conf");
            try {
                this.generateDirectoryStructure(out, request, response, conf);
            }
            catch (IOException ioe) {
                String msg = ioe.getLocalizedMessage();
                int i = msg.indexOf("\n");
                if (i >= 0) {
                    msg = msg.substring(0, i);
                }
                out.print("<h3>" + msg + "</h3>");
            }
            out.write("\n<hr>\n\n<h2>Local logs</h2>\n<a href=\"/logs/\">Log</a> directory\n\n");
            out.println(ServletUtil.htmlFooter());
            out.write(10);
        }
        catch (Throwable t) {
            try {
                if (!(t instanceof SkipPageException)) {
                    out = _jspx_out;
                    if (out != null && out.getBufferSize() != 0) {
                        out.clearBuffer();
                    }
                    if (_jspx_page_context != null) {
                        _jspx_page_context.handlePageException(t);
                    }
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                _jspxFactory.releasePageContext(_jspx_page_context);
            }
        }
        _jspxFactory.releasePageContext(_jspx_page_context);
    }
}

