/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.wps_hadoop.common;

import com.terradue.wps_hadoop.common.XmlInputFormat;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.Reducer;
import org.apache.log4j.Logger;
import org.n52.wps.io.data.IData;
import org.n52.wps.server.AbstractAlgorithm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HadoopAbstractAlgorithm<OK, OV>
extends AbstractAlgorithm {
    protected final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    protected Configuration hadoopConfig = new Configuration();
    protected FileSystem hdfs = null;
    protected String hdfsPrefix;

    protected abstract Class<? extends Mapper<?, ?, OK, OV>> getMapper();

    protected Class<? extends Reducer<OK, OV, ?, ?>> getReducer() {
        return null;
    }

    protected abstract JobConf getJobConf();

    protected abstract String getJobName();

    protected abstract Path[] getInputPaths(Map<String, List<IData>> var1);

    protected abstract String getOutputPath();

    public final Map<String, IData> run(Map<String, List<IData>> inputData) {
        this.prepareToRun(inputData);
        this.logger.info((Object)"Getting JobConf");
        this.hadoopConfig.set("io.sort.mb", "20");
        JobConf conf = this.getJobConf();
        if (conf == null) {
            conf = new JobConf(this.hadoopConfig);
        }
        this.logger.info((Object)"Setting JobName");
        conf.setJobName(this.getJobName());
        this.logger.info((Object)"getting Mapper Class");
        conf.setMapperClass(this.getMapper());
        if (this.getReducer() != null) {
            this.logger.info((Object)"getting Reducer Class");
            conf.setReducerClass(this.getReducer());
        }
        this.logger.info((Object)"Setting Input Paths ");
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{this.getInputPaths(inputData)[0]});
        this.logger.info((Object)("getting OutputPath " + this.getOutputPath()));
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(this.getOutputPath()));
        conf.setInputFormat(XmlInputFormat.class);
        try {
            this.logger.info((Object)"Running Job...");
            JobClient.runJob((JobConf)conf);
        }
        catch (IOException e) {
            throw new RuntimeException("Error accessing to Input/Output Path", e);
        }
        this.logger.info((Object)"Building results");
        return this.buildResults();
    }

    protected void prepareToRun(Map<String, List<IData>> inputData) {
    }

    protected abstract Map<String, IData> buildResults();
}

