/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.parser.stax.util;

import javax.xml.namespace.QName;
import org.apache.abdera.model.Element;
import org.apache.abdera.parser.stax.FOMFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.traverse.OMChildrenIterator;

public class FOMExtensionIterator
extends OMChildrenIterator {
    private String namespace = null;
    private String extns = null;
    private FOMFactory factory = null;
    private boolean needToMoveForward = true;
    private boolean isMatchingNodeFound = false;

    public FOMExtensionIterator(OMElement parent) {
        super(parent.getFirstOMChild());
        this.namespace = parent.getQName().getNamespaceURI();
        this.factory = (FOMFactory)parent.getOMFactory();
    }

    public FOMExtensionIterator(OMElement parent, String extns) {
        this(parent);
        this.extns = extns;
    }

    public boolean hasNext() {
        while (this.needToMoveForward) {
            if (this.currentChild != null) {
                if (this.currentChild instanceof OMElement && this.isQNamesMatch(((OMElement)this.currentChild).getQName(), this.namespace)) {
                    this.isMatchingNodeFound = true;
                    this.needToMoveForward = false;
                    continue;
                }
                this.currentChild = this.currentChild.getNextOMSibling();
                this.needToMoveForward = this.currentChild != null;
                this.isMatchingNodeFound = this.needToMoveForward;
                continue;
            }
            this.needToMoveForward = false;
        }
        return this.isMatchingNodeFound;
    }

    public Object next() {
        this.needToMoveForward = true;
        this.isMatchingNodeFound = false;
        this.nextCalled = true;
        this.removeCalled = false;
        this.lastChild = this.currentChild;
        this.currentChild = this.currentChild.getNextOMSibling();
        return this.factory.getElementWrapper((Element)this.lastChild);
    }

    private boolean isQNamesMatch(QName elementQName, String namespace) {
        boolean namespaceURIMatch;
        String elns = elementQName == null ? "" : elementQName.getNamespaceURI();
        boolean bl = namespaceURIMatch = namespace == null || namespace == "" || elns.equals(namespace);
        if (!namespaceURIMatch && this.extns != null && !elns.equals(this.extns)) {
            return false;
        }
        return !namespaceURIMatch;
    }
}

