/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.traverse;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNode;

public class OMChildrenIterator
implements Iterator {
    protected OMNode currentChild;
    protected OMNode lastChild;
    protected boolean nextCalled = false;
    protected boolean removeCalled = false;

    public OMChildrenIterator(OMNode currentChild) {
        this.currentChild = currentChild;
    }

    public void remove() {
        if (!this.nextCalled) {
            throw new IllegalStateException("next method has not yet being called");
        }
        if (this.removeCalled) {
            throw new IllegalStateException("remove has already being called");
        }
        this.removeCalled = true;
        if (this.lastChild == null) {
            throw new OMException("cannot remove a child at this stage!");
        }
        this.lastChild.detach();
    }

    public boolean hasNext() {
        return this.currentChild != null;
    }

    public Object next() {
        this.nextCalled = true;
        this.removeCalled = false;
        if (this.hasNext()) {
            this.lastChild = this.currentChild;
            this.currentChild = this.currentChild.getNextOMSibling();
            return this.lastChild;
        }
        throw new NoSuchElementException();
    }
}

