/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.resources.kxml.service.version;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gcube.common.resources.kxml.service.version.ArtifactVersion;
import org.gcube.common.resources.kxml.service.version.DefaultArtifactImpl;
import org.gcube.common.resources.kxml.service.version.Restriction;

public class VersionSpecificationParser {
    public static Range parse(String spec) throws InvalidVersionException {
        if (spec == null) {
            throw new InvalidVersionException("Null range");
        }
        ArrayList<Restriction> restrictions = new ArrayList<Restriction>();
        String process = spec;
        DefaultArtifactImpl version = null;
        ArtifactVersion upperBound = null;
        ArtifactVersion lowerBound = null;
        while (process.startsWith("[") || process.startsWith("(")) {
            int index2;
            int index1 = process.indexOf(")");
            int index = index2 = process.indexOf("]");
            if ((index2 < 0 || index1 < index2) && index1 >= 0) {
                index = index1;
            }
            if (index < 0) {
                throw new InvalidVersionException("Unbounded range: " + spec);
            }
            Restriction restriction = VersionSpecificationParser.parseRestriction(process.substring(0, index + 1));
            if (lowerBound == null) {
                lowerBound = restriction.getLowerBound();
            }
            if (upperBound != null && (restriction.getLowerBound() == null || restriction.getLowerBound().compareTo(upperBound) < 0)) {
                throw new InvalidVersionException("Ranges overlap: " + spec);
            }
            restrictions.add(restriction);
            upperBound = restriction.getUpperBound();
            if ((process = process.substring(index + 1).trim()).length() <= 0 || !process.startsWith(",")) continue;
            process = process.substring(1).trim();
        }
        if (process.length() > 0) {
            if (restrictions.size() > 0) {
                throw new InvalidVersionException("Only fully-qualified sets allowed in multiple set scenario: " + spec);
            }
            version = new DefaultArtifactImpl(process);
            restrictions.add(Restriction.EVERYTHING);
        }
        return new Range(version, restrictions);
    }

    private static Restriction parseRestriction(String spec) throws InvalidVersionException {
        Restriction restriction;
        boolean lowerBoundInclusive = spec.startsWith("[");
        boolean upperBoundInclusive = spec.endsWith("]");
        String process = spec.substring(1, spec.length() - 1).trim();
        int index = process.indexOf(",");
        if (index < 0) {
            if (!lowerBoundInclusive || !upperBoundInclusive) {
                throw new InvalidVersionException("Single version must be surrounded by []: " + spec);
            }
            DefaultArtifactImpl version = new DefaultArtifactImpl(process);
            restriction = new Restriction(version, lowerBoundInclusive, version, upperBoundInclusive);
        } else {
            String upperBound;
            String lowerBound = process.substring(0, index).trim();
            if (lowerBound.equals(upperBound = process.substring(index + 1).trim())) {
                throw new InvalidVersionException("Range cannot have identical boundaries: " + spec);
            }
            DefaultArtifactImpl lowerVersion = null;
            if (lowerBound.length() > 0) {
                lowerVersion = new DefaultArtifactImpl(lowerBound);
            }
            DefaultArtifactImpl upperVersion = null;
            if (upperBound.length() > 0) {
                upperVersion = new DefaultArtifactImpl(upperBound);
            }
            if (upperVersion != null && lowerVersion != null && upperVersion.compareTo(lowerVersion) < 0) {
                throw new InvalidVersionException("Range defies version ordering: " + spec);
            }
            restriction = new Restriction(lowerVersion, lowerBoundInclusive, upperVersion, upperBoundInclusive);
        }
        return restriction;
    }

    public static class InvalidVersionException
    extends Exception {
        private static final long serialVersionUID = -1592821816921603892L;

        InvalidVersionException(String message) {
            super(message);
        }
    }

    public static class Range {
        private final ArtifactVersion recommendedVersion;
        private final List<Restriction> restrictions;

        Range(ArtifactVersion recommendedVersion, List<Restriction> restrictions) {
            this.recommendedVersion = recommendedVersion;
            this.restrictions = restrictions;
        }

        public ArtifactVersion getRecommendedVersion() {
            return this.recommendedVersion;
        }

        public List<Restriction> getRestrictions() {
            return this.restrictions;
        }

        public String toString() {
            if (this.recommendedVersion != null) {
                return this.recommendedVersion.toString();
            }
            StringBuffer buf = new StringBuffer();
            Iterator<Restriction> i = this.restrictions.iterator();
            while (i.hasNext()) {
                Restriction r = i.next();
                buf.append(r.toString());
                if (!i.hasNext()) continue;
                buf.append(",");
            }
            return buf.toString();
        }
    }
}

