/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.resources.kxml.runninginstance;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.resources.runninginstance.RIEquivalenceFunction;
import org.gcube.common.core.resources.runninginstance.RunningInstanceSecurity;
import org.gcube.common.core.resources.runninginstance.ScopedAccounting;
import org.gcube.common.resources.kxml.GCUBEResourceImpl;
import org.gcube.common.resources.kxml.KGCUBEResource;
import org.gcube.common.resources.kxml.common.KPlatform;
import org.gcube.common.resources.kxml.runninginstance.KAccessPoint;
import org.gcube.common.resources.kxml.runninginstance.KDeploymentData;
import org.gcube.common.resources.kxml.runninginstance.KRIEquivalenceFunctions;
import org.gcube.common.resources.kxml.runninginstance.KRunningInstanceSecurity;
import org.gcube.common.resources.kxml.runninginstance.KScopedAccounting;
import org.gcube.common.resources.kxml.utils.KAny;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;

public class KGCUBERunningInstance
extends GCUBERunningInstance
implements GCUBEResourceImpl {
    @Override
    public synchronized void load(Reader reader) throws Exception {
        KGCUBEResource.load(this, reader);
    }

    @Override
    public synchronized void store(Writer writer) throws Exception {
        KGCUBEResource.store(this, writer);
    }

    @Override
    public InputStream getSchemaResource() {
        return KGCUBERunningInstance.class.getResourceAsStream("/org/gcube/common/resources/kxml/schemas/runninginstance.xsd");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void load(KXmlParser parser) throws Exception {
        this.getRunningInstanceSecurity().clear();
        this.getRIEquivalenceFunctions().clear();
        this.getAccounting().clear();
        while (true) {
            switch (parser.next()) {
                case 2: {
                    if (parser.getName().equals("Description")) {
                        this.setDescription(parser.nextText());
                    }
                    if (parser.getName().equals("Version")) {
                        this.setInstanceVersion(parser.nextText());
                    }
                    if (parser.getName().equals("GHN")) {
                        this.setGHNID(parser.getAttributeValue(KGCUBEResource.NS, "UniqueID"));
                    }
                    if (parser.getName().equals("Service")) {
                        this.setServiceID(parser.getAttributeValue(KGCUBEResource.NS, "UniqueID"));
                    }
                    if (parser.getName().equals("ServiceName")) {
                        this.setServiceName(parser.nextText());
                    }
                    if (parser.getName().equals("ServiceClass")) {
                        this.setServiceClass(parser.nextText());
                    }
                    if (parser.getName().equals("RunningInstanceSecurity")) {
                        this.getRunningInstanceSecurity().add(KRunningInstanceSecurity.load(parser));
                    }
                    if (parser.getName().equals("Platform")) {
                        this.setPlatform(KPlatform.load(parser, "Platform"));
                    }
                    if (parser.getName().equals("DeploymentData")) {
                        this.setDeploymentData(KDeploymentData.load(parser));
                    }
                    if (parser.getName().equals("RIEquivalenceFunctions")) {
                        this.getRIEquivalenceFunctions().add(KRIEquivalenceFunctions.load(parser));
                    }
                    if (parser.getName().equals("AccessPoint")) {
                        this.setAccessPoint(KAccessPoint.load(parser));
                    }
                    if (parser.getName().equals("SpecificData")) {
                        this.setSpecificData(KAny.load("SpecificData", parser));
                    }
                    if (!parser.getName().equals("Accounting")) break;
                    this.getAccounting().putAll(KScopedAccounting.load(parser));
                    break;
                }
                case 3: {
                    if (!parser.getName().equals("Profile")) break;
                    return;
                }
                case 1: {
                    throw new Exception("Parsing failed at Profile");
                }
            }
        }
    }

    @Override
    public void store(KXmlSerializer serializer) throws Exception {
        serializer.startTag(KGCUBEResource.NS, "Profile");
        if (this.getDescription() != null) {
            serializer.startTag(KGCUBEResource.NS, "Description").text(this.getDescription()).endTag(KGCUBEResource.NS, "Description");
        }
        if (this.getInstanceVersion() != null) {
            serializer.startTag(KGCUBEResource.NS, "Version").text(this.getInstanceVersion()).endTag(KGCUBEResource.NS, "Version");
        }
        if (this.getGHNID() != null) {
            serializer.startTag(KGCUBEResource.NS, "GHN").attribute(KGCUBEResource.NS, "UniqueID", this.getGHNID()).endTag(KGCUBEResource.NS, "GHN");
        }
        if (this.getServiceID() != null) {
            serializer.startTag(KGCUBEResource.NS, "Service").attribute(KGCUBEResource.NS, "UniqueID", this.getServiceID()).endTag(KGCUBEResource.NS, "Service");
        }
        if (this.getServiceName() != null) {
            serializer.startTag(KGCUBEResource.NS, "ServiceName").text(this.getServiceName()).endTag(KGCUBEResource.NS, "ServiceName");
        }
        if (this.getServiceClass() != null) {
            serializer.startTag(KGCUBEResource.NS, "ServiceClass").text(this.getServiceClass()).endTag(KGCUBEResource.NS, "ServiceClass");
        }
        if (this.getRunningInstanceSecurity().size() != 0) {
            serializer.startTag(KGCUBEResource.NS, "RunningInstanceSecurity");
            for (RunningInstanceSecurity runningInstanceSecurity : this.getRunningInstanceSecurity()) {
                KRunningInstanceSecurity.store(runningInstanceSecurity, serializer);
            }
            serializer.endTag(KGCUBEResource.NS, "RunningInstanceSecurity");
        }
        if (this.getPlatform() != null) {
            KPlatform.store(this.getPlatform(), serializer, "Platform");
        }
        if (this.getDeploymentData() != null) {
            KDeploymentData.store(this.getDeploymentData(), serializer);
        }
        if (this.getRIEquivalenceFunctions().size() != 0) {
            serializer.startTag(KGCUBEResource.NS, "RIEquivalenceFunctions");
            for (RIEquivalenceFunction rIEquivalenceFunction : this.getRIEquivalenceFunctions()) {
                KRIEquivalenceFunctions.store(rIEquivalenceFunction, serializer);
            }
            serializer.endTag(KGCUBEResource.NS, "RIEquivalenceFunctions");
        }
        if (this.getAccessPoint() != null) {
            KAccessPoint.store(this.getAccessPoint(), serializer);
        }
        KAny.store("SpecificData", this.getSpecificData(), serializer);
        if (this.getAccounting().size() != 0) {
            serializer.startTag(KGCUBEResource.NS, "Accounting");
            for (ScopedAccounting scopedAccounting : this.getAccounting().values()) {
                KScopedAccounting.store(scopedAccounting, serializer);
            }
            serializer.endTag(KGCUBEResource.NS, "Accounting");
        }
        serializer.endTag(KGCUBEResource.NS, "Profile");
    }

    public static void main(String[] args) {
        KGCUBERunningInstance ri = new KGCUBERunningInstance();
        try {
            KGCUBEResource.load(ri, new FileReader(args[0]));
            KGCUBEResource.store(ri, new FileWriter(args[1]));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("SERVICECLASS " + ri.getServiceClass());
        for (ScopedAccounting ac : ri.getAccounting().values()) {
            System.out.println(ac.getScope());
            System.out.println(ac.getTopCallerGHNavgDailyCalls());
            System.out.println(ac.getTopCallerGHN());
            System.out.println(ac.getTopCallerGHNavgHourlyCalls());
            System.out.println(ac.getTopCallerGHNtotalCalls());
            for (Long key : ac.getAverageCallsMap().keySet()) {
                System.out.println(key + "--->" + ac.getAverageCallsMap().get(key));
            }
            for (Long key : ac.getAverageTimeMap().keySet()) {
                System.out.println(key + "--->" + ac.getAverageTimeMap().get(key));
            }
        }
        try {
            GCUBERunningInstance ris = GHNContext.getImplementation(GCUBERunningInstance.class);
            ris.load(new FileReader(args[0]));
            ris.store(new FileWriter(args[2]));
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        System.out.println("SERVICECLASS " + ri.getServiceClass());
        for (ScopedAccounting ac : ri.getAccounting().values()) {
            System.out.println(ac.getScope());
            System.out.println(ac.getTopCallerGHNavgDailyCalls());
            System.out.println(ac.getTopCallerGHN());
            System.out.println(ac.getTopCallerGHNavgHourlyCalls());
            System.out.println(ac.getTopCallerGHNtotalCalls());
            for (Long key : ac.getAverageCallsMap().keySet()) {
                System.out.println(key + "--->" + ac.getAverageCallsMap().get(key));
            }
            for (Long key : ac.getAverageTimeMap().keySet()) {
                System.out.println(key + "--->" + ac.getAverageTimeMap().get(key));
            }
        }
    }
}

