/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.utils.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.handlers.GCUBEIHandler;
import org.gcube.common.core.utils.logging.GCUBELog;

public abstract class GCUBEComplexHandler<HANDLED>
extends GCUBEHandler<HANDLED> {
    private List<GCUBEIHandler<? extends HANDLED>> handlers = new ArrayList<GCUBEIHandler<? extends HANDLED>>();

    public GCUBEComplexHandler(GCUBEIHandler<? extends HANDLED> ... components) {
        this.addHandlers(components);
    }

    public synchronized void addHandlers(GCUBEIHandler<? extends HANDLED> ... components) throws IllegalArgumentException {
        if (components == null) {
            throw new IllegalArgumentException("null is not a valid argument");
        }
        this.handlers.addAll(Arrays.asList(components));
    }

    @Override
    public void setLogger(GCUBELog logger) {
        super.setLogger(logger);
        for (GCUBEIHandler<HANDLED> handler : this.getHandlers()) {
            handler.setLogger(this.getLogger());
        }
    }

    public synchronized boolean removeHandler(GCUBEIHandler<? extends HANDLED> component) {
        return this.handlers.remove(component);
    }

    public synchronized List<GCUBEIHandler<? extends HANDLED>> getHandlers() {
        return new ArrayList<GCUBEIHandler<? extends HANDLED>>(this.handlers);
    }

    @Override
    public synchronized void undo() {
        ListIterator<GCUBEIHandler<HANDLED>> i = this.handlers.listIterator(this.handlers.size());
        while (i.hasPrevious()) {
            i.previous().undo();
        }
    }
}

