/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.utils.events;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.core.utils.events.GCUBEConsumer;
import org.gcube.common.core.utils.events.GCUBEEvent;
import org.gcube.common.core.utils.events.GCUBESynchronousConsumer;
import org.gcube.common.core.utils.events.GCUBETopic;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.handlers.GCUBEScheduledHandler;
import org.gcube.common.core.utils.logging.GCUBELog;

public class GCUBEProducer<TOPIC extends GCUBETopic, PAYLOAD> {
    protected GCUBELog logger = new GCUBELog(this);
    protected Map<TOPIC, List<GCUBEConsumer<TOPIC, PAYLOAD>>> consumers = new HashMap<TOPIC, List<GCUBEConsumer<TOPIC, PAYLOAD>>>();
    protected Map<TOPIC, List<GCUBEEvent<? extends TOPIC, ? extends PAYLOAD>>> events = new HashMap<TOPIC, List<GCUBEEvent<? extends TOPIC, ? extends PAYLOAD>>>();
    protected static List<GCUBEProducer<?, ?>> classExtent = new ArrayList();
    protected static EventSweeper sweeper;

    public GCUBEProducer() {
        classExtent.add(this);
    }

    protected List<GCUBEConsumer<TOPIC, PAYLOAD>> getConsumers(TOPIC topic) {
        if (this.consumers.get(topic) == null) {
            this.consumers.put(topic, new ArrayList());
        }
        return this.consumers.get(topic);
    }

    protected List<GCUBEEvent<? extends TOPIC, ? extends PAYLOAD>> getEvents(TOPIC topic) {
        if (this.events.get(topic) == null) {
            this.events.put(topic, new ArrayList());
        }
        return this.events.get(topic);
    }

    public synchronized void subscribe(GCUBEConsumer<TOPIC, PAYLOAD> consumer, TOPIC ... topics) throws IllegalArgumentException {
        if (topics == null || topics.length == 0) {
            throw new IllegalArgumentException("no topics specified");
        }
        for (TOPIC topic : topics) {
            List<GCUBEConsumer<TOPIC, PAYLOAD>> consumers = this.getConsumers(topic);
            if (consumers.contains(consumer)) {
                return;
            }
            consumers.add(consumer);
            List<GCUBEEvent<TOPIC, PAYLOAD>> events = this.getEvents(topic);
            if (events.size() <= 0) continue;
            this.notifyConsumer(consumer, events.toArray(new GCUBEEvent[events.size()]));
        }
    }

    public synchronized void unsubscribe(GCUBEConsumer<TOPIC, PAYLOAD> consumer, TOPIC ... topics) throws IllegalArgumentException {
        if (topics == null || topics.length == 0) {
            throw new IllegalArgumentException("no topics specified");
        }
        for (TOPIC topic : topics) {
            List<GCUBEConsumer<TOPIC, PAYLOAD>> consumers = this.getConsumers(topic);
            consumers.remove(consumer);
        }
    }

    protected <T1 extends TOPIC, P1 extends PAYLOAD> void notifyConsumer(final GCUBEConsumer<TOPIC, PAYLOAD> consumer, final GCUBEEvent<T1, P1> ... events) {
        if (consumer instanceof GCUBESynchronousConsumer) {
            consumer.onEvent(events);
        } else {
            new Thread(){

                @Override
                public void run() {
                    Thread.currentThread().setName(consumer.getClass().isAnonymousClass() ? consumer.getClass().getSuperclass().getSimpleName() + "$<anon>" : consumer.getClass().getSimpleName());
                    consumer.onEvent(events);
                }
            }.start();
        }
    }

    public synchronized <T1 extends TOPIC, P1 extends PAYLOAD> void notify(T1 topic, GCUBEEvent<T1, P1> ... events) throws IllegalArgumentException {
        if (topic == null || events == null || events.length == 0) {
            throw new IllegalArgumentException("no topic or events");
        }
        List<GCUBEEvent<T1, PAYLOAD>> eventList = this.getEvents(topic);
        for (GCUBEEvent<T1, P1> event : events) {
            event.setProducer(this);
            event.setTopic(topic);
            eventList.add(event);
        }
        for (GCUBEConsumer<T1, PAYLOAD> consumer : this.getConsumers(topic)) {
            this.notifyConsumer(consumer, events);
        }
    }

    private synchronized long sweepEvents() {
        Calendar now = Calendar.getInstance();
        long totalRemoved = 0L;
        ArrayList<GCUBEEvent<TOPIC, PAYLOAD>> toRemove = new ArrayList<GCUBEEvent<TOPIC, PAYLOAD>>();
        for (GCUBETopic topic : this.events.keySet()) {
            for (GCUBEEvent<TOPIC, PAYLOAD> event : this.events.get(topic)) {
                if (!event.isExpired(now)) continue;
                toRemove.add(event);
            }
            if (toRemove.size() <= 0) continue;
            this.events.get(topic).removeAll(toRemove);
            totalRemoved += (long)toRemove.size();
            toRemove.clear();
        }
        return totalRemoved;
    }

    static {
        new Thread(){

            @Override
            public void run() {
                sweeper = new EventSweeper();
            }
        }.start();
    }

    private static class EventSweeper
    extends GCUBEScheduledHandler<Object> {
        private static final int SWEEPER_DELAY = 60;

        protected EventSweeper() {
            super(60L, GCUBEScheduledHandler.Mode.LAZY, new GCUBEHandler<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() throws Exception {
                    int totalRemoved = 0;
                    Class<EventSweeper> clazz = EventSweeper.class;
                    synchronized (EventSweeper.class) {
                        for (GCUBEProducer<?, ?> producer : classExtent) {
                            totalRemoved = (int)((long)totalRemoved + ((GCUBEProducer)producer).sweepEvents());
                        }
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        if (totalRemoved > 0) {
                            this.logger.debug("sweeped " + totalRemoved + " expired events");
                        }
                        return;
                    }
                }
            });
            this.getScheduled().setName(this.getName());
            try {
                this.run();
            }
            catch (Exception e) {
                throw new RuntimeException("could not start event sweeper", e);
            }
        }

        @Override
        protected boolean repeat(Exception exception, int exceptionCount) {
            if (exception != null) {
                this.logger.warn("Event sweeper failed (" + exceptionCount + ")");
            }
            return true;
        }
    }
}

