/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.state;

import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.state.GCUBEStatefulResource;

public abstract class GCUBELocalResource
extends GCUBEStatefulResource<String> {
    private int links = 1;
    protected GCUBEServiceContext context;

    @Override
    protected void initialise(String id, Object ... params) throws Exception {
        super.setID(id != null ? id : uuidGen.nextUUID());
        this.logger.trace("initialising " + this.getClass().getSimpleName() + "(" + (String)this.getID() + ")");
    }

    public synchronized int getLinks() {
        return this.links;
    }

    public synchronized void addLink() {
        ++this.links;
        this.logger.debug("increased sharing for " + this.getClass().getSimpleName() + "(" + (String)this.getID() + ") to " + this.links);
    }

    public synchronized void removeLink() {
        --this.links;
        this.logger.debug("decreased sharing for " + this.getClass().getSimpleName() + "(" + (String)this.getID() + ") to " + this.links);
    }

    public synchronized void setLinks(int links) {
        if (links > 0) {
            this.links = links;
        }
    }

    @Override
    public GCUBEServiceContext getServiceContext() {
        return this.context;
    }

    public void setServiceContext(GCUBEServiceContext context) {
        if (this.context != null) {
            throw new RuntimeException("context already configured");
        }
        this.context = context;
        this.logger.setContext(context);
    }
}

