/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.security.utils;

import java.util.HashSet;
import java.util.Set;

class DefaultSecurityConfigurationBean {
    private String auth_method;
    private Set<String> protection_level = new HashSet<String>();
    private boolean enabled = false;
    private boolean override = false;
    public static final String GSI_SECURE_CONVERSATION = "GSISecureConversation";
    public static final String GSI_SECURE_TRANSPORT = "GSITransport";
    public static final String PL_PRIVACY = "privacy";
    public static final String PL_INTEGRITY = "integrity";
    public static final String NONE = "none";

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isOverride() {
        return this.override;
    }

    public void setOverride(String override) {
        this.override = override != null && override.equalsIgnoreCase("true");
    }

    public String getIn_auth_method() {
        return this.auth_method;
    }

    public void setAuth_method(String auth_method) throws Exception {
        this.auth_method = this.parseAuthMethod(auth_method);
    }

    private String parseAuthMethod(String authMethod) throws Exception {
        String response = null;
        if (authMethod.equalsIgnoreCase(GSI_SECURE_CONVERSATION)) {
            response = GSI_SECURE_CONVERSATION;
        } else if (authMethod.equalsIgnoreCase(GSI_SECURE_TRANSPORT)) {
            response = GSI_SECURE_TRANSPORT;
        } else if (authMethod.equalsIgnoreCase(NONE)) {
            response = NONE;
        } else {
            throw new Exception("Invalid auth method " + authMethod);
        }
        return response;
    }

    public Set<String> getIn_protection_levels() {
        return this.protection_level;
    }

    public void addProtection_level(String protection_level) throws Exception {
        if (this.protection_level.size() == 2) {
            throw new Exception("Too many prot level");
        }
        this.protection_level.add(this.parseProtectionLevel(protection_level));
    }

    private String parseProtectionLevel(String protLevel) throws Exception {
        protLevel = protLevel.toLowerCase();
        String response = null;
        if (!protLevel.equals(PL_PRIVACY) && !protLevel.equals(PL_INTEGRITY)) {
            throw new Exception("Invalid protection level " + protLevel);
        }
        response = protLevel;
        return response;
    }
}

