/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.resources.service;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Version {
    public static String completeVersionRange(String version) {
        Matcher matcher = Pattern.compile("(\\d{1,2})\\.(\\d{1,2})\\.(\\d{1,2})").matcher(version);
        boolean result = matcher.find();
        if (result) {
            StringBuffer sb = new StringBuffer();
            do {
                matcher.appendReplacement(sb, Version.completeVersion(matcher.group()));
            } while (result = matcher.find());
            matcher.appendTail(sb);
            return sb.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Attempt to set an invalid range version ").append(" to ").append(version);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public static String completeVersion(String version) {
        Pattern pattern = Pattern.compile("^(\\d{1,2})\\.(\\d{1,2})\\.(\\d{1,2})$");
        Matcher matcher = pattern.matcher(version.trim());
        if (matcher.find()) {
            StringBuilder compiledVersion = new StringBuilder();
            compiledVersion.append(version.substring(matcher.start(1), matcher.end(1))).append(".");
            if (version.substring(matcher.start(2), matcher.end(2)).length() < 2) {
                compiledVersion.append("0");
            }
            compiledVersion.append(version.substring(matcher.start(2), matcher.end(2))).append(".");
            if (version.substring(matcher.start(3), matcher.end(3)).length() < 2) {
                compiledVersion.append("0");
            }
            compiledVersion.append(version.substring(matcher.start(3), matcher.end(3)));
            if (compiledVersion.toString().startsWith("0") && !compiledVersion.toString().startsWith("0.")) {
                return compiledVersion.toString().substring(1);
            }
            return compiledVersion.toString();
        }
        throw new IllegalArgumentException("Invalid version " + version);
    }
}

