/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.tools.wsdl;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.PortType;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.dom.DOMInputImpl;
import org.apache.xerces.impl.xs.XMLSchemaLoader;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSNamespaceItem;
import org.apache.xerces.xs.XSNamespaceItemList;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTerm;
import org.globus.wsrf.tools.CommandLineTool;
import org.globus.wsrf.tools.wsdl.RelativePathUtil;
import org.globus.wsrf.tools.wsdl.TypesProcessor;
import org.globus.wsrf.tools.wsdl.WSDLPreprocessorConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class WSDLPreprocessor
extends CommandLineTool
implements WSDLPreprocessorConstants {
    private static int nameSpaceCounter = 0;
    private static boolean wsaImport = false;
    private static Log logger = LogFactory.getLog((class$org$globus$wsrf$tools$wsdl$WSDLPreprocessor == null ? (class$org$globus$wsrf$tools$wsdl$WSDLPreprocessor = WSDLPreprocessor.class$("org.globus.wsrf.tools.wsdl.WSDLPreprocessor")) : class$org$globus$wsrf$tools$wsdl$WSDLPreprocessor).getName());
    private static boolean quiet = false;
    static /* synthetic */ Class class$org$globus$wsrf$tools$wsdl$WSDLPreprocessor;
    static /* synthetic */ Class class$javax$wsdl$PortType;

    public static void main(String[] args) {
        String msg;
        QName portTypeName = null;
        String outFileName = null;
        String inFileName = null;
        CommandLine commandLine = null;
        WSDLFactory factory = null;
        Options options = new Options();
        Option option = null;
        HelpFormatter formatter = new HelpFormatter();
        PortType portType = null;
        Definition definition = null;
        FileOutputStream outFile = null;
        HashMap schemaDocumentLocations = new HashMap();
        try {
            factory = WSDLFactory.newInstance();
        }
        catch (Exception e) {
            String msg2 = "ERROR: Failed to load WSDL parser implementation";
            logger.error(msg2, e);
            System.err.println(msg2);
            WSDLPreprocessor.sysExit(1);
        }
        WSDLReader reader = factory.newWSDLReader();
        WSDLWriter writer = factory.newWSDLWriter();
        reader.setFeature("javax.wsdl.verbose", false);
        reader.setFeature("javax.wsdl.importDocuments", false);
        option = new Option("o", "out", true, "Specifies the file to write the processed WSDL to (default STDOUT)");
        option.setArgName("FILE");
        options.addOption(option);
        option = new Option("p", "porttype", true, "Specifies the top level porttype to process");
        option.setArgName("PORTTYPE");
        options.addOption(option);
        option = new Option("i", "in", true, "Specifies the file containing the WSDL to process");
        option.setArgName("FILE");
        options.addOption(option);
        options.addOption("h", "help", false, "Prints this help message");
        options.addOption("q", "quiet", false, "Don't print warnings");
        GnuParser parser = new GnuParser();
        try {
            commandLine = parser.parse(options, args);
        }
        catch (Exception e) {
            logger.error("", e);
            formatter.printHelp((class$org$globus$wsrf$tools$wsdl$WSDLPreprocessor == null ? (class$org$globus$wsrf$tools$wsdl$WSDLPreprocessor = WSDLPreprocessor.class$("org.globus.wsrf.tools.wsdl.WSDLPreprocessor")) : class$org$globus$wsrf$tools$wsdl$WSDLPreprocessor).getName(), options, true);
            WSDLPreprocessor.sysExit(1);
        }
        if (commandLine.hasOption('h')) {
            formatter.printHelp((class$org$globus$wsrf$tools$wsdl$WSDLPreprocessor == null ? (class$org$globus$wsrf$tools$wsdl$WSDLPreprocessor = WSDLPreprocessor.class$("org.globus.wsrf.tools.wsdl.WSDLPreprocessor")) : class$org$globus$wsrf$tools$wsdl$WSDLPreprocessor).getName(), options, true);
            WSDLPreprocessor.sysExit(0);
        }
        if (commandLine.hasOption('p')) {
            portTypeName = new QName(commandLine.getOptionValue('p'));
        }
        inFileName = commandLine.getOptionValue('i');
        if (commandLine.hasOption('o')) {
            outFileName = commandLine.getOptionValue('o');
        }
        if (commandLine.hasOption('q')) {
            quiet = true;
        }
        if ((args = commandLine.getArgs()).length != 0) {
            formatter.printHelp((class$org$globus$wsrf$tools$wsdl$WSDLPreprocessor == null ? (class$org$globus$wsrf$tools$wsdl$WSDLPreprocessor = WSDLPreprocessor.class$("org.globus.wsrf.tools.wsdl.WSDLPreprocessor")) : class$org$globus$wsrf$tools$wsdl$WSDLPreprocessor).getName(), options, false);
            WSDLPreprocessor.sysExit(1);
        }
        try {
            definition = reader.readWSDL(null, inFileName);
        }
        catch (Exception e) {
            String msg3 = "ERROR: Couldn't read WSDL input file " + inFileName;
            logger.error(msg3, e);
            System.err.println(msg3);
            WSDLPreprocessor.sysExit(1);
        }
        TypesProcessor typesProcessor = new TypesProcessor(definition);
        try {
            portType = typesProcessor.getPortType(portTypeName);
        }
        catch (Exception e) {
            String msg4 = "ERROR: Couldn't find " + (portTypeName == null ? "any" : portTypeName.toString()) + " porttype.";
            logger.error(msg4, e);
            System.err.println(msg4);
            WSDLPreprocessor.sysExit(1);
        }
        portTypeName = portType.getQName();
        ExtensionRegistry extensionAttributes = new ExtensionRegistry();
        extensionAttributes.registerExtensionAttributeType(class$javax$wsdl$PortType == null ? (class$javax$wsdl$PortType = WSDLPreprocessor.class$("javax.wsdl.PortType")) : class$javax$wsdl$PortType, WSDLPreprocessorConstants.EXTENDS, 3);
        extensionAttributes.registerExtensionAttributeType(class$javax$wsdl$PortType == null ? (class$javax$wsdl$PortType = WSDLPreprocessor.class$("javax.wsdl.PortType")) : class$javax$wsdl$PortType, WSDLPreprocessorConstants.RP, 1);
        reader.setExtensionRegistry(extensionAttributes);
        try {
            if (!quiet) {
                reader.setFeature("javax.wsdl.verbose", true);
            }
            reader.setFeature("javax.wsdl.importDocuments", true);
            definition = reader.readWSDL(null, inFileName);
        }
        catch (Exception e) {
            String msg5 = "ERROR: Couldn't read WSDL input file " + inFileName;
            logger.error(msg5, e);
            System.err.println(msg5);
            WSDLPreprocessor.sysExit(1);
        }
        typesProcessor = new TypesProcessor(definition);
        portType = definition.getPortType(portTypeName);
        List portTypeNames = WSDLPreprocessor.getDependencies(portType);
        HashMap resourcePropertyElements = new HashMap();
        WSDLPreprocessor.flatten(portType, definition, definition, portTypeNames, resourcePropertyElements, schemaDocumentLocations);
        if (!resourcePropertyElements.isEmpty()) {
            try {
                typesProcessor.addResourceProperties(portTypeName, resourcePropertyElements, schemaDocumentLocations);
            }
            catch (Exception e) {
                msg = "ERROR: Failed to add resource properties";
                logger.error(msg, e);
                System.err.println(msg);
                System.err.println(e.toString());
                WSDLPreprocessor.sysExit(2);
            }
        }
        if (wsaImport) {
            try {
                typesProcessor.addWSAImport(schemaDocumentLocations);
            }
            catch (Exception e) {
                msg = "ERROR: Failed to add WSA XSD import";
                logger.error(msg, e);
                System.err.println(msg);
                System.err.println(e.toString());
                WSDLPreprocessor.sysExit(2);
            }
        }
        try {
            outFile = outFileName != null ? new FileOutputStream(outFileName) : new FileOutputStream(FileDescriptor.out);
        }
        catch (Exception e) {
            msg = "ERROR: Couldn't open output file " + (outFileName == null ? "STDOUT" : outFileName);
            logger.error(msg, e);
            System.err.println(msg);
            WSDLPreprocessor.sysExit(1);
        }
        try {
            writer.writeWSDL(definition, outFile);
            if (outFileName != null) {
                try {
                    outFile.close();
                }
                catch (Exception ee) {}
            }
        }
        catch (Exception e) {
            if (outFileName != null) {
                try {
                    outFile.close();
                }
                catch (Exception ee) {
                    // empty catch block
                }
            }
            msg = "ERROR: Failed to process WSDL";
            logger.error(msg, e);
            System.err.println(msg);
            System.err.println(e.toString());
            WSDLPreprocessor.sysExit(3);
        }
    }

    private static PortType flatten(PortType portType, Definition definition, Definition parentDefinition, List portTypeNames, Map resourcePropertyElements, Map schemaDocumentLocations) {
        Map portTypes = definition.getPortTypes();
        Iterator portTypeIterator = portTypes.values().iterator();
        while (portTypeIterator.hasNext()) {
            List newDependencies;
            PortType currentPortType = (PortType)portTypeIterator.next();
            if (portTypeNames == null || !portTypeNames.contains(currentPortType.getQName())) continue;
            logger.debug("Found porttype: " + currentPortType.getQName());
            QName resourceProperties = (QName)currentPortType.getExtensionAttribute(WSDLPreprocessorConstants.RP);
            if (resourceProperties != null) {
                logger.debug("Adding resource properties for porttype: " + currentPortType.getQName());
                resourcePropertyElements.putAll(WSDLPreprocessor.getResourceProperties(resourceProperties, definition, schemaDocumentLocations));
            }
            if ((newDependencies = WSDLPreprocessor.getDependencies(currentPortType)) != null && !newDependencies.isEmpty()) {
                WSDLPreprocessor.flatten(currentPortType, definition, parentDefinition, newDependencies, resourcePropertyElements, schemaDocumentLocations);
                if (!newDependencies.isEmpty() && definition != parentDefinition) {
                    System.err.println("WARNING: The following porttypes are missing:");
                    Iterator portTypeNamesIterator = newDependencies.iterator();
                    while (portTypeNamesIterator.hasNext()) {
                        System.err.println("\t" + ((QName)portTypeNamesIterator.next()).toString());
                    }
                }
            }
            WSDLPreprocessor.fixNameSpaces(currentPortType, parentDefinition);
            List operations = currentPortType.getOperations();
            ListIterator operationsIterator = operations.listIterator();
            while (operationsIterator.hasNext()) {
                Operation operation = (Operation)operationsIterator.next();
                Input input = operation.getInput();
                Output output = operation.getOutput();
                if (portType.getOperation(operation.getName(), input == null ? null : input.getName(), output == null ? null : output.getName()) != null) continue;
                if (input != null && input.getExtensionAttribute(WSDLPreprocessorConstants.WSA_ACTION) != null) {
                    wsaImport = true;
                    Element schema = WSDLPreprocessor.getSchemaElement(definition);
                    if (schema != null) {
                        XSModel schemaModel = WSDLPreprocessor.loadSchema(schema, definition);
                        WSDLPreprocessor.populateLocations(schemaModel, schemaDocumentLocations, definition);
                    }
                }
                portType.addOperation(operation);
            }
            WSDLPreprocessor.addImports(definition, parentDefinition);
            portTypeNames.remove(currentPortType.getQName());
        }
        if (portTypeNames == null || portTypeNames.isEmpty()) {
            return portType;
        }
        if (definition == parentDefinition) {
            HashMap imports = new HashMap();
            imports.putAll(definition.getImports());
            Iterator importNSIterator = imports.values().iterator();
            while (importNSIterator.hasNext() && !portTypeNames.isEmpty()) {
                Vector importVector = (Vector)importNSIterator.next();
                Iterator importIterator = importVector.iterator();
                while (importIterator.hasNext() && !portTypeNames.isEmpty()) {
                    Import importDef = (Import)importIterator.next();
                    WSDLPreprocessor.flatten(portType, importDef.getDefinition(), parentDefinition, portTypeNames, resourcePropertyElements, schemaDocumentLocations);
                }
            }
            if (!portTypeNames.isEmpty() && !quiet) {
                System.err.println("WARNING: The following porttypes are missing:");
                Iterator portTypeNamesIterator = portTypeNames.iterator();
                while (portTypeNamesIterator.hasNext()) {
                    System.err.println("\t" + ((QName)portTypeNamesIterator.next()).toString());
                }
            }
        }
        return portType;
    }

    private static void addImports(Definition definition, Definition parentDefinition) {
        Collection imports = definition.getImports().values();
        Iterator importsIterator = imports.iterator();
        while (importsIterator.hasNext()) {
            Vector importsVector = (Vector)importsIterator.next();
            Iterator importsVectorIterator = importsVector.iterator();
            boolean addImport = true;
            while (importsVectorIterator.hasNext()) {
                List parentImports;
                Import currentImport = (Import)importsVectorIterator.next();
                String location = currentImport.getLocationURI();
                if (location != null && (location.startsWith(".") || location.indexOf(47) == -1)) {
                    location = WSDLPreprocessor.getRelativePath(parentDefinition.getDocumentBaseURI(), currentImport.getDefinition().getDocumentBaseURI());
                    currentImport.setLocationURI(location);
                }
                if ((parentImports = parentDefinition.getImports(currentImport.getNamespaceURI())) != null) {
                    Iterator parentImportsIterator = parentImports.iterator();
                    while (parentImportsIterator.hasNext()) {
                        Import parentImport = (Import)parentImportsIterator.next();
                        if (!parentImport.getLocationURI().equals(location)) continue;
                        addImport = false;
                        break;
                    }
                }
                if (addImport) {
                    parentDefinition.addImport(currentImport);
                }
                addImport = true;
            }
        }
    }

    private static List getDependencies(PortType portType) {
        List result = (List)portType.getExtensionAttribute(WSDLPreprocessorConstants.EXTENDS);
        if (result != null) {
            portType.getExtensionAttributes().remove(WSDLPreprocessorConstants.EXTENDS);
        }
        return result;
    }

    private static Element getSchemaElement(Definition def) {
        Types types = def.getTypes();
        if (types == null) {
            return null;
        }
        List elementList = types.getExtensibilityElements();
        if (elementList.isEmpty()) {
            return null;
        }
        return ((UnknownExtensibilityElement)elementList.get(0)).getElement();
    }

    private static XSModel loadSchema(Element schema, Definition def) {
        Map definitionNameSpaces = def.getNamespaces();
        Set nameSpaces = definitionNameSpaces.entrySet();
        Iterator nameSpacesIterator = nameSpaces.iterator();
        while (nameSpacesIterator.hasNext()) {
            Map.Entry nameSpaceEntry = nameSpacesIterator.next();
            if ("".equals((String)nameSpaceEntry.getKey()) || schema.hasAttributeNS("http://www.w3.org/2000/xmlns/", (String)nameSpaceEntry.getKey())) continue;
            Attr nameSpace = schema.getOwnerDocument().createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + nameSpaceEntry.getKey());
            nameSpace.setValue((String)nameSpaceEntry.getValue());
            schema.setAttributeNode(nameSpace);
        }
        DOMInputImpl schemaInput = new DOMInputImpl();
        schemaInput.setStringData("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + XMLUtils.ElementToString(schema));
        logger.debug("Loading schema in types section of definition " + def.getDocumentBaseURI());
        schemaInput.setSystemId(def.getDocumentBaseURI());
        XMLSchemaLoader schemaLoader = new XMLSchemaLoader();
        XSModel schemaModel = schemaLoader.load(schemaInput);
        logger.debug("Done loading");
        return schemaModel;
    }

    private static void populateLocations(XSModel schemaModel, Map documentLocations, Definition def) {
        String documentURI = def.getDocumentBaseURI();
        XSNamespaceItemList namespaceItemList = schemaModel.getNamespaceItems();
        for (int i = 0; i < namespaceItemList.getLength(); ++i) {
            XSNamespaceItem namespaceItem = namespaceItemList.item(i);
            HashMap<String, Object> locations = (HashMap<String, Object>)documentLocations.get(namespaceItem.getSchemaNamespace());
            if (locations == null) {
                locations = new HashMap<String, Object>();
                documentLocations.put(namespaceItem.getSchemaNamespace(), locations);
            }
            StringList list = namespaceItem.getDocumentLocations();
            for (int j = 0; j < list.getLength(); ++j) {
                String uri = URLDecoder.decode(list.item(j));
                if (uri.equals(documentURI)) continue;
                locations.put(list.item(j), null);
            }
        }
    }

    public static Map getResourceProperties(QName resourceProperties, Definition def, Map documentLocations) {
        HashMap<QName, XSParticle> resourcePropertyElements = new HashMap<QName, XSParticle>();
        if (resourceProperties != null) {
            Element schema;
            XSModel schemaModel;
            XSElementDeclaration resourcePropertiesElement;
            Types types = def.getTypes();
            if (types == null) {
                if (!quiet) {
                    System.err.println("WARNING: The " + def.getDocumentBaseURI() + " definition does not have a types section");
                }
                return resourcePropertyElements;
            }
            List elementList = types.getExtensibilityElements();
            if (elementList.size() > 1 && !quiet) {
                System.err.println("WARNING: The types section in " + def.getDocumentBaseURI() + " contains more than one top level element.");
            }
            if ((resourcePropertiesElement = (schemaModel = WSDLPreprocessor.loadSchema(schema = ((UnknownExtensibilityElement)elementList.get(0)).getElement(), def)).getElementDeclaration(resourceProperties.getLocalPart(), resourceProperties.getNamespaceURI())) != null) {
                XSComplexTypeDecl type = (XSComplexTypeDecl)resourcePropertiesElement.getTypeDefinition();
                XSParticle particle = type.getParticle();
                XSModelGroup sequence = (XSModelGroup)particle.getTerm();
                XSObjectList objectList = sequence.getParticles();
                for (int i = 0; i < objectList.getLength(); ++i) {
                    XSParticle part = (XSParticle)objectList.item(i);
                    XSTerm term = part.getTerm();
                    if (term instanceof XSElementDeclaration) {
                        XSElementDeclaration resourceProperty = (XSElementDeclaration)term;
                        resourcePropertyElements.put(new QName(resourceProperty.getNamespace(), resourceProperty.getName()), part);
                        continue;
                    }
                    System.err.println("ERROR: Invalid resource properties document " + resourceProperties.toString());
                    WSDLPreprocessor.sysExit(1);
                }
            } else {
                Map imports = def.getImports();
                Iterator importNSIterator = imports.values().iterator();
                while (importNSIterator.hasNext() && resourcePropertyElements.isEmpty()) {
                    Vector importVector = (Vector)importNSIterator.next();
                    Iterator importIterator = importVector.iterator();
                    while (importIterator.hasNext() && resourcePropertyElements.isEmpty()) {
                        Import importDef = (Import)importIterator.next();
                        resourcePropertyElements.putAll(WSDLPreprocessor.getResourceProperties(resourceProperties, importDef.getDefinition(), documentLocations));
                    }
                }
                if (resourcePropertyElements.isEmpty()) {
                    System.err.println("ERROR: Unable to resolve resource properties " + resourceProperties.toString());
                    WSDLPreprocessor.sysExit(1);
                }
            }
            WSDLPreprocessor.populateLocations(schemaModel, documentLocations, def);
        }
        return resourcePropertyElements;
    }

    private static void fixNameSpaces(PortType porttype, Definition definition) {
        List operations = porttype.getOperations();
        Iterator operationsIterator = operations.iterator();
        while (operationsIterator.hasNext()) {
            Map faults;
            Message outMessage;
            Output output;
            Message inMessage;
            Operation operation = (Operation)operationsIterator.next();
            Input input = operation.getInput();
            if (input != null && (inMessage = input.getMessage()) != null && definition.getPrefix(inMessage.getQName().getNamespaceURI()) == null) {
                definition.addNamespace("gtwsdl" + String.valueOf(nameSpaceCounter++), inMessage.getQName().getNamespaceURI());
            }
            if ((output = operation.getOutput()) != null && (outMessage = output.getMessage()) != null && definition.getPrefix(outMessage.getQName().getNamespaceURI()) == null) {
                definition.addNamespace("gtwsdl" + String.valueOf(nameSpaceCounter++), outMessage.getQName().getNamespaceURI());
            }
            if ((faults = operation.getFaults()) == null) continue;
            Iterator faultIterator = faults.values().iterator();
            while (faultIterator.hasNext()) {
                Message faultMessage = ((Fault)faultIterator.next()).getMessage();
                if (definition.getPrefix(faultMessage.getQName().getNamespaceURI()) != null) continue;
                definition.addNamespace("gtwsdl" + String.valueOf(nameSpaceCounter++), faultMessage.getQName().getNamespaceURI());
            }
        }
    }

    protected static String getRelativePath(String srcPathURI, String destPathURI) {
        String destPath = URLDecoder.decode(destPathURI.substring(5));
        String srcPath = URLDecoder.decode(srcPathURI.substring(5));
        return RelativePathUtil.getRelativeFileName(new File(destPath), new File(srcPath));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

