/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.timer;

import commonj.timers.StopTimerListener;
import commonj.timers.TimerListener;
import commonj.timers.TimerManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.globus.wsrf.impl.timer.TimerImpl;
import org.globus.wsrf.impl.timer.TimerListenerWrapper;

public class TimerManagerImpl
implements TimerManager {
    private int poolSize = 1;
    private List taskList = new LinkedList();
    private List timerPool = new ArrayList();
    private int currentTimer = 0;

    public TimerManagerImpl() {
        for (int i = 0; i < this.poolSize; ++i) {
            this.timerPool.add(new Timer(true));
        }
    }

    public synchronized void resume() {
        Iterator taskIterator = this.taskList.iterator();
        while (taskIterator.hasNext()) {
            ((TimerListenerWrapper)taskIterator.next()).resume();
        }
    }

    public commonj.timers.Timer schedule(TimerListener listener, Date firstTime, long period) {
        Timer timer = (Timer)this.timerPool.get(this.currentTimer);
        this.currentTimer = (this.currentTimer + 1) % this.poolSize;
        TimerImpl newTimer = new TimerImpl(listener, period);
        TimerListenerWrapper task = new TimerListenerWrapper(newTimer, this);
        this.taskList.add(task);
        timer.schedule((TimerTask)task, firstTime, period);
        return newTimer;
    }

    public commonj.timers.Timer schedule(TimerListener listener, Date time) {
        Timer timer = (Timer)this.timerPool.get(this.currentTimer);
        this.currentTimer = (this.currentTimer + 1) % this.poolSize;
        TimerImpl newTimer = new TimerImpl(listener, 0L);
        TimerListenerWrapper task = new TimerListenerWrapper(newTimer, this);
        this.taskList.add(task);
        timer.schedule((TimerTask)task, time);
        return newTimer;
    }

    public commonj.timers.Timer schedule(TimerListener listener, long delay, long period) {
        Timer timer = (Timer)this.timerPool.get(this.currentTimer);
        this.currentTimer = (this.currentTimer + 1) % this.poolSize;
        TimerImpl newTimer = new TimerImpl(listener, period);
        TimerListenerWrapper task = new TimerListenerWrapper(newTimer, this);
        this.taskList.add(task);
        timer.schedule((TimerTask)task, delay, period);
        return newTimer;
    }

    public commonj.timers.Timer schedule(TimerListener listener, long delay) {
        Timer timer = (Timer)this.timerPool.get(this.currentTimer);
        this.currentTimer = (this.currentTimer + 1) % this.poolSize;
        TimerImpl newTimer = new TimerImpl(listener, 0L);
        TimerListenerWrapper task = new TimerListenerWrapper(newTimer, this);
        this.taskList.add(task);
        timer.schedule((TimerTask)task, delay);
        return newTimer;
    }

    public commonj.timers.Timer scheduleAtFixedRate(TimerListener listener, Date firstTime, long period) {
        Timer timer = (Timer)this.timerPool.get(this.currentTimer);
        this.currentTimer = (this.currentTimer + 1) % this.poolSize;
        TimerImpl newTimer = new TimerImpl(listener, period);
        TimerListenerWrapper task = new TimerListenerWrapper(newTimer, this);
        this.taskList.add(task);
        timer.scheduleAtFixedRate((TimerTask)task, firstTime, period);
        return newTimer;
    }

    public commonj.timers.Timer scheduleAtFixedRate(TimerListener listener, long delay, long period) {
        Timer timer = (Timer)this.timerPool.get(this.currentTimer);
        this.currentTimer = (this.currentTimer + 1) % this.poolSize;
        TimerImpl newTimer = new TimerImpl(listener, period);
        TimerListenerWrapper task = new TimerListenerWrapper(newTimer, this);
        this.taskList.add(task);
        timer.scheduleAtFixedRate((TimerTask)task, delay, period);
        return newTimer;
    }

    public synchronized void stop() {
        Iterator taskIterator = this.taskList.iterator();
        while (taskIterator.hasNext()) {
            TimerListenerWrapper task = (TimerListenerWrapper)taskIterator.next();
            task.stop();
            TimerListener listener = task.getListener();
            if (!(listener instanceof StopTimerListener)) continue;
            ((StopTimerListener)listener).timerStop(task.getTimer());
        }
        this.taskList.clear();
    }

    public synchronized void suspend() {
        Iterator taskIterator = this.taskList.iterator();
        while (taskIterator.hasNext()) {
            ((TimerListenerWrapper)taskIterator.next()).suspend();
        }
    }

    protected synchronized void removeTask(Object task) {
        this.taskList.remove(task);
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        for (int i = this.poolSize; i < poolSize; ++i) {
            this.timerPool.add(new Timer(true));
        }
        this.poolSize = poolSize;
    }
}

