/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authentication;

import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.wsrf.impl.security.authentication.DescriptorHandler;
import org.globus.wsrf.impl.security.descriptor.AuthMethod;
import org.globus.wsrf.impl.security.descriptor.NoneAuthMethod;
import org.globus.wsrf.impl.security.descriptor.ResourceSecurityDescriptor;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityDescriptor;
import org.globus.wsrf.impl.security.util.AuthUtil;
import org.globus.wsrf.security.SecurityException;

public class AuthHandler
extends DescriptorHandler {
    private static Log logger = LogFactory.getLog(AuthHandler.class.getName());
    public static final List DEFAULT_AUTH_METHODS = new Vector();

    public void handle(MessageContext msgCtx, ResourceSecurityDescriptor resDesc, ServiceSecurityDescriptor desc, String servicePath) throws AxisFault {
        if (resDesc == null && desc == null) {
            logger.debug("Resource desc and service desc are null, return");
            return;
        }
        QName opName = null;
        try {
            opName = AuthUtil.getOperationName(msgCtx);
        }
        catch (SecurityException exp) {
            throw AxisFault.makeFault(exp);
        }
        logger.debug("Method invoked " + opName);
        msgCtx.setProperty("org.globus.security.operationName", opName);
        List authMethods = null;
        ServiceSecurityDescriptor descUsed = null;
        if (resDesc != null) {
            authMethods = resDesc.getAuthMethods(opName);
            if (authMethods == null) {
                authMethods = resDesc.getDefaultAuthMethods();
            }
            descUsed = resDesc;
        }
        if (authMethods == null && desc != null) {
            authMethods = desc.getAuthMethods(opName);
            if (authMethods == null) {
                authMethods = desc.getDefaultAuthMethods();
            }
            descUsed = desc;
        }
        if (authMethods == null) {
            authMethods = DEFAULT_AUTH_METHODS;
            descUsed = desc == null ? desc : resDesc;
        }
        logger.debug("Checking authentication methods");
        int size = authMethods.size();
        Boolean authzReq = Boolean.FALSE;
        for (int i = 0; i < size; ++i) {
            if (authMethods.get(i).equals(NoneAuthMethod.getInstance())) continue;
            authzReq = Boolean.TRUE;
            break;
        }
        msgCtx.setProperty("org.globus.security.authz.required", authzReq);
        if (Boolean.FALSE.equals(authzReq)) {
            logger.debug("No auth, so no point verifiying");
            return;
        }
        for (int i = 0; i < size; ++i) {
            AuthMethod method = (AuthMethod)authMethods.get(i);
            logger.debug("Configured Method " + method.getName());
            if (!method.isAuthenticated(msgCtx)) continue;
            logger.debug("Returned true, valid mechanism");
            return;
        }
        throw new AxisFault(descUsed.getRequiredAuthMethodsErrorMessage(authMethods, opName));
    }

    static {
        DEFAULT_AUTH_METHODS.add(NoneAuthMethod.getInstance());
    }
}

