/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl;

import org.apache.axis.AxisEngine;
import org.apache.axis.MessageContext;
import org.apache.axis.enum.Scope;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.utils.cache.ClassCache;
import org.apache.axis.utils.cache.JavaClass;
import org.globus.axis.providers.RPCProvider;
import org.globus.util.I18n;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.impl.SingletonResourceHome;
import org.globus.wsrf.jndi.Initializable;
import org.globus.wsrf.utils.Resources;

public class ServiceResourceHome
extends SingletonResourceHome
implements Initializable {
    private static I18n i18n = I18n.getI18n(Resources.class.getName());
    private Resource service;

    public synchronized void initialize() throws Exception {
        if (this.service != null) {
            return;
        }
        MessageContext msgContext = MessageContext.getCurrentContext();
        if (msgContext == null) {
            throw new Exception(i18n.getMessage("noMsgContext"));
        }
        String targetService = msgContext.getTargetService();
        if (targetService == null) {
            throw new Exception(i18n.getMessage("noTargetServiceSet"));
        }
        SOAPService service = msgContext.getService();
        if (service == null) {
            throw new Exception(i18n.getMessage("noServiceSet"));
        }
        Scope scope = Scope.getScope((String)service.getOption("scope"), Scope.DEFAULT);
        if (scope != Scope.APPLICATION) {
            throw new Exception(i18n.getMessage("applicationScopeNeeded", targetService));
        }
        AxisEngine engine = msgContext.getAxisEngine();
        Object serviceInstance = engine.getApplicationSession().get(targetService);
        if (serviceInstance == null) {
            ClassCache cache;
            JavaClass jc;
            String clsName = (String)service.getOption("className");
            ClassLoader cl = msgContext.getClassLoader();
            if (!Resource.class.isAssignableFrom((jc = (cache = engine.getClassCache()).lookup(clsName, cl)).getJavaClass())) {
                throw new Exception(i18n.getMessage("invalidResourceType", jc.getJavaClass().getName()));
            }
            serviceInstance = RPCProvider.getNewServiceInstance(msgContext, jc.getJavaClass());
            engine.getApplicationSession().set(targetService, serviceInstance);
        }
        this.service = (Resource)serviceInstance;
    }

    protected Resource findSingleton() throws ResourceException {
        return this.service;
    }
}

