/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tools.gar;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class GenerateUndeploy {
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            throw new Exception("Usage: GenerateUndeploy <gar file> <undeploy dir>");
        }
        JarFile jar = new JarFile(args[0]);
        String garID = new File(args[0]).getName();
        int extensionPos = garID.lastIndexOf(46);
        if (extensionPos != -1) {
            garID = garID.substring(0, extensionPos);
        }
        String baseDir = args[1] + File.separator + "etc" + File.separator + "globus_packages" + File.separator + garID + File.separator;
        File dir = new File(baseDir);
        dir.mkdirs();
        FileWriter file = new FileWriter(baseDir + "undeploy.xml");
        PrintWriter out = new PrintWriter(file);
        out.println("<project default=\"undeploy\" basedir=\".\">");
        out.println("\n");
        out.println("<property environment=\"env\"/>");
        out.println("<property file=\"build.properties\"/>");
        out.println("<property file=\"${user.home}/build.properties\"/>");
        out.println("<property name=\"env.GLOBUS_LOCATION\" value=\"../../..\"/>");
        out.println("<property name=\"deploy.dir\" value=\"${env.GLOBUS_LOCATION}\"/>");
        out.println("\n");
        out.println("<target name=\"undeploy\">");
        out.println("  <delete verbose=\"true\" dir=\"${deploy.dir}/etc/" + garID + "\"/>");
        Enumeration<JarEntry> e = jar.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            String name = entry.getName();
            if (entry.isDirectory()) {
                if (name.equals("docs/")) {
                    out.println("  <delete verbose=\"true\" dir=\"${deploy.dir}/docs/" + garID + "\"/>");
                    continue;
                }
                if (!name.equals("share/")) continue;
                out.println("  <delete verbose=\"true\" dir=\"${deploy.dir}/share/" + garID + "\"/>");
                continue;
            }
            if (name.startsWith("lib/")) {
                String nm = name.substring("lib/".length());
                if (name.endsWith(".jar")) {
                    out.println("  <delete verbose=\"true\" file=\"${deploy.dir}/lib/" + nm + "\"/>");
                    continue;
                }
                if (nm.indexOf("LICENSE") == -1) continue;
                out.println("  <delete verbose=\"true\" file=\"${deploy.dir}/share/licenses/" + nm + "\"/>");
                continue;
            }
            if (name.startsWith("schema/")) {
                out.println("  <delete verbose=\"true\" file=\"${deploy.dir}/share/" + name + "\"/>");
                continue;
            }
            if (!name.startsWith("bin/")) continue;
            out.println("  <delete verbose=\"true\" file=\"${deploy.dir}/" + name + "\"/>");
        }
        out.println("</target>");
        out.println("</project>");
        out.flush();
        out.close();
    }
}

