/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli2.validation;

import java.io.File;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.cli2.validation.InvalidArgumentException;
import org.apache.commons.cli2.validation.Validator;

public class FileValidator
implements Validator {
    private boolean readable = false;
    private boolean writable = false;
    private boolean existing = false;
    private boolean directory = false;
    private boolean file = false;
    private boolean hidden = false;

    public static FileValidator getExistingInstance() {
        FileValidator validator = new FileValidator();
        validator.setExisting(true);
        return validator;
    }

    public static FileValidator getExistingFileInstance() {
        FileValidator validator = new FileValidator();
        validator.setExisting(true);
        validator.setFile(true);
        return validator;
    }

    public static FileValidator getExistingDirectoryInstance() {
        FileValidator validator = new FileValidator();
        validator.setExisting(true);
        validator.setDirectory(true);
        return validator;
    }

    public void validate(List values) throws InvalidArgumentException {
        ListIterator<File> i = values.listIterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            File f = new File(name);
            if (this.existing && !f.exists() || this.file && !f.isFile() || this.directory && !f.isDirectory() || this.hidden && !f.isHidden() || this.readable && !f.canRead() || this.writable && !f.canWrite()) {
                throw new InvalidArgumentException(name);
            }
            i.set(f);
        }
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public void setDirectory(boolean directory) {
        this.directory = directory;
    }

    public boolean isExisting() {
        return this.existing;
    }

    public void setExisting(boolean existing) {
        this.existing = existing;
    }

    public boolean isFile() {
        return this.file;
    }

    public void setFile(boolean file) {
        this.file = file;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public void setReadable(boolean readable) {
        this.readable = readable;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public void setWritable(boolean writable) {
        this.writable = writable;
    }
}

