/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli2.option;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.cli2.Argument;
import org.apache.commons.cli2.DisplaySetting;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.WriteableCommandLine;
import org.apache.commons.cli2.option.HelpLineImpl;
import org.apache.commons.cli2.option.OptionImpl;
import org.apache.commons.cli2.option.ReverseStringComparator;

public class GroupImpl
extends OptionImpl
implements Group {
    private final String name;
    private final String description;
    private final List options;
    private final int minimum;
    private final int maximum;
    private final List anonymous;
    private final SortedMap optionMap;
    private final Set prefixes;

    public GroupImpl(List options, String name, String description, int minimum, int maximum) {
        super(0, false);
        this.name = name;
        this.description = description;
        this.minimum = minimum;
        this.maximum = maximum;
        this.options = Collections.unmodifiableList(options);
        ArrayList<Option> newAnonymous = new ArrayList<Option>();
        TreeMap newOptionMap = new TreeMap(ReverseStringComparator.getInstance());
        HashSet newPrefixes = new HashSet();
        Iterator i = options.iterator();
        while (i.hasNext()) {
            Option option = (Option)i.next();
            if (option instanceof Argument) {
                i.remove();
                newAnonymous.add(option);
                continue;
            }
            Set triggers = option.getTriggers();
            Iterator j = triggers.iterator();
            while (j.hasNext()) {
                newOptionMap.put(j.next(), option);
            }
            newPrefixes.addAll(option.getPrefixes());
        }
        this.anonymous = Collections.unmodifiableList(newAnonymous);
        this.optionMap = Collections.unmodifiableSortedMap(newOptionMap);
        this.prefixes = Collections.unmodifiableSet(newPrefixes);
    }

    public boolean canProcess(WriteableCommandLine commandLine, String arg) {
        if (arg == null) {
            return false;
        }
        if (this.optionMap.containsKey(arg)) {
            return true;
        }
        SortedMap tailMap = this.optionMap.tailMap(arg);
        Iterator iter = tailMap.values().iterator();
        while (iter.hasNext()) {
            Option option = (Option)iter.next();
            if (!option.canProcess(commandLine, arg)) continue;
            return true;
        }
        if (commandLine.looksLikeOption(arg)) {
            return false;
        }
        return this.anonymous.size() > 0;
    }

    public Set getPrefixes() {
        return this.prefixes;
    }

    public Set getTriggers() {
        return this.optionMap.keySet();
    }

    public void process(WriteableCommandLine commandLine, ListIterator arguments) throws OptionException {
        String previous = null;
        while (arguments.hasNext()) {
            String arg = (String)arguments.next();
            if (arg == previous) {
                arguments.previous();
                break;
            }
            previous = arg;
            Option opt = (Option)this.optionMap.get(arg);
            if (opt != null) {
                arguments.previous();
                opt.process(commandLine, arguments);
                continue;
            }
            if (commandLine.looksLikeOption(arg)) {
                Collection values = this.optionMap.tailMap(arg).values();
                boolean foundMemberOption = false;
                Iterator i = values.iterator();
                while (i.hasNext() && !foundMemberOption) {
                    Option option = (Option)i.next();
                    if (!option.canProcess(commandLine, arg)) continue;
                    foundMemberOption = true;
                    arguments.previous();
                    option.process(commandLine, arguments);
                }
                if (foundMemberOption) continue;
                arguments.previous();
                return;
            }
            arguments.previous();
            if (this.anonymous.isEmpty()) break;
            Iterator i = this.anonymous.iterator();
            while (i.hasNext()) {
                Argument argument = (Argument)i.next();
                if (!argument.canProcess(commandLine, arguments)) continue;
                argument.process(commandLine, arguments);
            }
        }
    }

    public void validate(WriteableCommandLine commandLine) throws OptionException {
        Option option;
        int present = 0;
        Option unexpected = null;
        Iterator i = this.options.iterator();
        while (i.hasNext()) {
            option = (Option)i.next();
            if (option.isRequired()) {
                option.validate(commandLine);
            }
            if (option instanceof Group) {
                option.validate(commandLine);
            }
            if (!commandLine.hasOption(option)) continue;
            if (++present > this.maximum) {
                unexpected = option;
                break;
            }
            option.validate(commandLine);
        }
        if (unexpected != null) {
            throw new OptionException(this, "Unexpected.token", unexpected.getPreferredName());
        }
        if (present < this.minimum) {
            throw new OptionException(this, "Missing.option");
        }
        i = this.anonymous.iterator();
        while (i.hasNext()) {
            option = (Option)i.next();
            option.validate(commandLine);
        }
    }

    public String getPreferredName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void appendUsage(StringBuffer buffer, Set helpSettings, Comparator comp) {
        this.appendUsage(buffer, helpSettings, comp, "|");
    }

    public void appendUsage(StringBuffer buffer, Set helpSettings, Comparator comp, String separator) {
        boolean both;
        HashSet helpSettingsCopy = new HashSet(helpSettings);
        boolean optional = this.minimum == 0 && helpSettingsCopy.contains(DisplaySetting.DISPLAY_OPTIONAL);
        boolean expanded = this.name == null || helpSettingsCopy.contains(DisplaySetting.DISPLAY_GROUP_EXPANDED);
        boolean named = !expanded || this.name != null && helpSettingsCopy.contains(DisplaySetting.DISPLAY_GROUP_NAME);
        boolean arguments = helpSettingsCopy.contains(DisplaySetting.DISPLAY_GROUP_ARGUMENT);
        boolean outer = helpSettingsCopy.contains(DisplaySetting.DISPLAY_GROUP_OUTER);
        helpSettingsCopy.remove(DisplaySetting.DISPLAY_GROUP_OUTER);
        boolean bl = both = named && expanded;
        if (optional) {
            buffer.append('[');
        }
        if (named) {
            buffer.append(this.name);
        }
        if (both) {
            buffer.append(" (");
        }
        if (expanded) {
            ArrayList list;
            HashSet childSettings;
            if (!helpSettingsCopy.contains(DisplaySetting.DISPLAY_GROUP_EXPANDED)) {
                childSettings = DisplaySetting.NONE;
            } else {
                childSettings = new HashSet(helpSettingsCopy);
                childSettings.remove(DisplaySetting.DISPLAY_OPTIONAL);
            }
            if (comp == null) {
                list = this.options;
            } else {
                list = new ArrayList(this.options);
                Collections.sort(list, comp);
            }
            Iterator i = list.iterator();
            while (i.hasNext()) {
                Option option = (Option)i.next();
                option.appendUsage(buffer, childSettings, comp);
                if (!i.hasNext()) continue;
                buffer.append(separator);
            }
        }
        if (both) {
            buffer.append(')');
        }
        if (optional && outer) {
            buffer.append(']');
        }
        if (arguments) {
            Iterator i = this.anonymous.iterator();
            while (i.hasNext()) {
                buffer.append(' ');
                Option option = (Option)i.next();
                option.appendUsage(buffer, helpSettingsCopy, comp);
            }
        }
        if (optional && !outer) {
            buffer.append(']');
        }
    }

    public List helpLines(int depth, Set helpSettings, Comparator comp) {
        ArrayList<HelpLineImpl> helpLines = new ArrayList<HelpLineImpl>();
        if (helpSettings.contains(DisplaySetting.DISPLAY_GROUP_NAME)) {
            HelpLineImpl helpLine = new HelpLineImpl(this, depth);
            helpLines.add(helpLine);
        }
        if (helpSettings.contains(DisplaySetting.DISPLAY_GROUP_EXPANDED)) {
            ArrayList list;
            if (comp == null) {
                list = this.options;
            } else {
                list = new ArrayList(this.options);
                Collections.sort(list, comp);
            }
            Iterator i = list.iterator();
            while (i.hasNext()) {
                Option option = (Option)i.next();
                helpLines.addAll(option.helpLines(depth + 1, helpSettings, comp));
            }
        }
        if (helpSettings.contains(DisplaySetting.DISPLAY_GROUP_ARGUMENT)) {
            Iterator i = this.anonymous.iterator();
            while (i.hasNext()) {
                Option option = (Option)i.next();
                helpLines.addAll(option.helpLines(depth + 1, helpSettings, comp));
            }
        }
        return helpLines;
    }

    public List getOptions() {
        return this.options;
    }

    public List getAnonymous() {
        return this.anonymous;
    }

    public Option findOption(String trigger) {
        Iterator i = this.getOptions().iterator();
        while (i.hasNext()) {
            Option option = (Option)i.next();
            Option found = option.findOption(trigger);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public boolean isRequired() {
        return this.getMinimum() > 0;
    }

    public void defaults(WriteableCommandLine commandLine) {
        Option option;
        super.defaults(commandLine);
        Iterator i = this.options.iterator();
        while (i.hasNext()) {
            option = (Option)i.next();
            option.defaults(commandLine);
        }
        i = this.anonymous.iterator();
        while (i.hasNext()) {
            option = (Option)i.next();
            option.defaults(commandLine);
        }
    }
}

