/*
 * Decompiled with CFR 0.152.
 */
package ise.library;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;

public class Log {
    private static File outfile = new File(System.getProperty("user.home"), "antelope_debug.log");
    private static final String LS = System.getProperty("line.separator");
    private static boolean canLog = true;

    public static void log(CharSequence msg) {
        Log.log(null, msg);
    }

    public static void log(Object o, CharSequence msg) {
        if (!canLog) {
            return;
        }
        try {
            FileWriter fw = new FileWriter(outfile, true);
            if (o != null) {
                fw.write(new Date().toString() + ": " + o.getClass().getName() + ": ");
            }
            fw.write(((Object)msg).toString());
            fw.write(LS);
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void log(Throwable t) {
        Log.log(null, t);
    }

    public static void log(Object o, Throwable t) {
        if (!canLog) {
            return;
        }
        Log.log(o, Log.getStackTrace(t));
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    static {
        System.out.println("Antelope debug log: " + outfile.getAbsolutePath());
    }
}

