/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks;

import ise.antelope.tasks.Grep;
import ise.antelope.tasks.PostTask;
import ise.antelope.tasks.Unset;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class ReadLog
extends Task {
    private URL logURL = null;
    private String property = null;
    private int minutes = 2;

    public void setUrl(URL url) {
        this.logURL = url;
    }

    public void setProperty(String name) {
        this.property = name;
    }

    public void setMinutes(int m) {
        this.minutes = m;
    }

    public void execute() {
        if (this.property == null) {
            throw new BuildException("Property is null.");
        }
        if (this.logURL == null) {
            throw new BuildException("URL is null.");
        }
        if (this.minutes < -1) {
            this.minutes = -1;
        }
        try {
            PostTask post = new PostTask();
            post.setProject(this.getProject());
            post.setTo(this.logURL);
            Date now = new Date();
            String temp_property = this.property + now.getTime();
            post.setProperty(temp_property);
            post.setVerbose(false);
            post.execute();
            String log = this.getProject().getProperty(temp_property);
            if (this.minutes == -1) {
                this.getProject().setProperty(this.property, log);
            } else {
                int i;
                long end_time = now.getTime() - (long)(this.minutes * 1000 * 60);
                String[] msgs = log.split("<hr>");
                for (i = 1; i < msgs.length; ++i) {
                    Grep grep = new Grep();
                    grep.setIn(msgs[i]);
                    grep.setRegex("(.*?[:].*?[:].*?)[:].*?");
                    grep.setGroup(1);
                    String start = grep.grep();
                    if (start == null) continue;
                    SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z");
                    try {
                        Date start_date = sdf.parse(start);
                        if (start_date.getTime() >= end_time) continue;
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                StringBuffer sb = new StringBuffer();
                for (int j = 1; j < i; ++j) {
                    sb.append(msgs[j]).append("\n");
                }
                this.getProject().setProperty(this.property, sb.toString());
            }
            Unset unset = new Unset();
            unset.setProject(this.getProject());
            unset.setName(temp_property);
            unset.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException(e.getMessage());
        }
    }
}

