/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.jcatalogue.client.download;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.terradue.jcatalogue.client.download.DownloadHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;

final class SimpleDownloadHandler
implements AsyncHandler<Void> {
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final int FILE_LENGTH = 1024;
    private final File targetFile;
    private final FileOutputStream output;
    private final DownloadHandler downloadHandler;
    private int contentLength = -1;
    private int downloadCounter = 0;

    public SimpleDownloadHandler(File targetFile, DownloadHandler downloadHandler) throws FileNotFoundException {
        this.targetFile = targetFile;
        this.output = new FileOutputStream(targetFile);
        this.downloadHandler = downloadHandler;
    }

    public void onThrowable(Throwable t) {
        this.downloadHandler.onError(t);
    }

    public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
        bodyPart.writeTo((OutputStream)this.output);
        if (this.contentLength > 0) {
            this.downloadCounter += bodyPart.getBodyPartBytes().length;
            int current = this.downloadCounter / 1024;
            int currentPercentage = 100 * current / this.contentLength;
            System.out.print(current + "/" + this.contentLength + "MB (" + currentPercentage + "%)\r");
        }
        return AsyncHandler.STATE.CONTINUE;
    }

    public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
        if (200 != responseStatus.getStatusCode()) {
            this.downloadHandler.onError(String.format("Impossible to download %s from %s, server replied %s", this.targetFile.getName(), this.targetFile.getName(), responseStatus.getStatusText()));
            this.targetFile.delete();
            return AsyncHandler.STATE.ABORT;
        }
        return AsyncHandler.STATE.CONTINUE;
    }

    public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        List contentLength = headers.getHeaders().get((Object)CONTENT_LENGTH);
        if (!contentLength.isEmpty()) {
            this.contentLength = Integer.valueOf((String)contentLength.iterator().next()) / 1024;
        }
        return AsyncHandler.STATE.CONTINUE;
    }

    public Void onCompleted() throws Exception {
        System.out.println("Done.");
        this.output.flush();
        this.output.close();
        this.downloadHandler.onCompleted(this.targetFile);
        return null;
    }
}

