/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.DataInputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.ImageLoader;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.ImageVisitor;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableUtils;

class ImageLoaderCurrent
implements ImageLoader {
    protected final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static int[] versions = new int[]{-16, -17, -18, -19};
    private int imageVersion = 0;

    ImageLoaderCurrent() {
    }

    @Override
    public boolean canLoadVersion(int version) {
        for (int v : versions) {
            if (v != version) continue;
            return true;
        }
        return false;
    }

    @Override
    public void loadImage(DataInputStream in, ImageVisitor v, boolean skipBlocks) throws IOException {
        try {
            v.start();
            v.visitEnclosingElement(ImageVisitor.ImageElement.FS_IMAGE);
            this.imageVersion = in.readInt();
            if (!this.canLoadVersion(this.imageVersion)) {
                throw new IOException("Cannot process fslayout version " + this.imageVersion);
            }
            v.visit(ImageVisitor.ImageElement.IMAGE_VERSION, this.imageVersion);
            v.visit(ImageVisitor.ImageElement.NAMESPACE_ID, in.readInt());
            long numInodes = in.readLong();
            v.visit(ImageVisitor.ImageElement.GENERATION_STAMP, in.readLong());
            this.processINodes(in, v, numInodes, skipBlocks);
            this.processINodesUC(in, v, skipBlocks);
            v.leaveEnclosingElement();
            v.finish();
        }
        catch (IOException e) {
            v.finishAbnormally();
            throw e;
        }
    }

    private void processINodesUC(DataInputStream in, ImageVisitor v, boolean skipBlocks) throws IOException {
        int numINUC = in.readInt();
        v.visitEnclosingElement(ImageVisitor.ImageElement.INODES_UNDER_CONSTRUCTION, ImageVisitor.ImageElement.NUM_INODES_UNDER_CONSTRUCTION, numINUC);
        for (int i = 0; i < numINUC; ++i) {
            v.visitEnclosingElement(ImageVisitor.ImageElement.INODE_UNDER_CONSTRUCTION);
            byte[] name = FSImage.readBytes(in);
            String n = new String(name, "UTF8");
            v.visit(ImageVisitor.ImageElement.INODE_PATH, n);
            v.visit(ImageVisitor.ImageElement.REPLICATION, in.readShort());
            v.visit(ImageVisitor.ImageElement.MODIFICATION_TIME, this.formatDate(in.readLong()));
            v.visit(ImageVisitor.ImageElement.PREFERRED_BLOCK_SIZE, in.readLong());
            int numBlocks = in.readInt();
            this.processBlocks(in, v, numBlocks, skipBlocks);
            this.processPermission(in, v);
            v.visit(ImageVisitor.ImageElement.CLIENT_NAME, FSImage.readString(in));
            v.visit(ImageVisitor.ImageElement.CLIENT_MACHINE, FSImage.readString(in));
            int numLocs = in.readInt();
            for (int j = 0; j < numLocs; ++j) {
                in.readShort();
                in.readLong();
                in.readLong();
                in.readLong();
                in.readInt();
                FSImage.readString(in);
                FSImage.readString(in);
                WritableUtils.readEnum(in, DatanodeInfo.AdminStates.class);
            }
            v.leaveEnclosingElement();
        }
        v.leaveEnclosingElement();
    }

    private void processBlocks(DataInputStream in, ImageVisitor v, int numBlocks, boolean skipBlocks) throws IOException {
        v.visitEnclosingElement(ImageVisitor.ImageElement.BLOCKS, ImageVisitor.ImageElement.NUM_BLOCKS, numBlocks);
        if (numBlocks == -1) {
            v.leaveEnclosingElement();
            return;
        }
        if (skipBlocks) {
            int bytesToSkip = 24 * numBlocks;
            if (in.skipBytes(bytesToSkip) != bytesToSkip) {
                throw new IOException("Error skipping over blocks");
            }
        } else {
            for (int j = 0; j < numBlocks; ++j) {
                v.visitEnclosingElement(ImageVisitor.ImageElement.BLOCK);
                v.visit(ImageVisitor.ImageElement.BLOCK_ID, in.readLong());
                v.visit(ImageVisitor.ImageElement.NUM_BYTES, in.readLong());
                v.visit(ImageVisitor.ImageElement.GENERATION_STAMP, in.readLong());
                v.leaveEnclosingElement();
            }
        }
        v.leaveEnclosingElement();
    }

    private void processPermission(DataInputStream in, ImageVisitor v) throws IOException {
        v.visitEnclosingElement(ImageVisitor.ImageElement.PERMISSIONS);
        v.visit(ImageVisitor.ImageElement.USER_NAME, Text.readString(in));
        v.visit(ImageVisitor.ImageElement.GROUP_NAME, Text.readString(in));
        FsPermission fsp = new FsPermission(in.readShort());
        v.visit(ImageVisitor.ImageElement.PERMISSION_STRING, fsp.toString());
        v.leaveEnclosingElement();
    }

    private void processINodes(DataInputStream in, ImageVisitor v, long numInodes, boolean skipBlocks) throws IOException {
        v.visitEnclosingElement(ImageVisitor.ImageElement.INODES, ImageVisitor.ImageElement.NUM_INODES, numInodes);
        for (long i = 0L; i < numInodes; ++i) {
            v.visitEnclosingElement(ImageVisitor.ImageElement.INODE);
            v.visit(ImageVisitor.ImageElement.INODE_PATH, FSImage.readString(in));
            v.visit(ImageVisitor.ImageElement.REPLICATION, in.readShort());
            v.visit(ImageVisitor.ImageElement.MODIFICATION_TIME, this.formatDate(in.readLong()));
            if (this.imageVersion <= -17) {
                v.visit(ImageVisitor.ImageElement.ACCESS_TIME, this.formatDate(in.readLong()));
            }
            v.visit(ImageVisitor.ImageElement.BLOCK_SIZE, in.readLong());
            int numBlocks = in.readInt();
            this.processBlocks(in, v, numBlocks, skipBlocks);
            if (numBlocks != 0) {
                v.visit(ImageVisitor.ImageElement.NS_QUOTA, numBlocks <= 0 ? in.readLong() : -1L);
                if (this.imageVersion <= -18) {
                    v.visit(ImageVisitor.ImageElement.DS_QUOTA, numBlocks <= 0 ? in.readLong() : -1L);
                }
            }
            this.processPermission(in, v);
            v.leaveEnclosingElement();
        }
        v.leaveEnclosingElement();
    }

    private String formatDate(long date) {
        return this.dateFormat.format(new Date(date));
    }
}

