/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.notification.impl.client;

import javax.xml.namespace.QName;
import org.apache.axis.encoding.AnyContentType;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.informationsystem.notification.impl.handlers.RemoveSubscriptionHandler;
import org.gcube.common.informationsystem.notification.impl.handlers.SubscribeToTopicHandler;
import org.gcube.informationsystem.notifier.stubs.SubscribeMessage;
import org.gcube.informationsystem.notifier.stubs.SubscribeToTopicResponse;
import org.globus.wsrf.utils.AnyHelper;
import org.oasis.wsn.GetCurrentMessage;
import org.oasis.wsn.GetCurrentMessageResponse;
import org.oasis.wsn.NotificationProducer;
import org.oasis.wsn.TopicExpressionType;
import org.oasis.wsn.WSBaseNotificationServiceAddressingLocator;

public class ISNotificationManager {
    private GCUBEScope scope;
    protected static final GCUBELog logger = new GCUBELog(ISNotificationManager.class);

    public ISNotificationManager(GCUBEScope gCUBEScope) {
        this.scope = gCUBEScope;
    }

    public EndpointReferenceType[] subscribeEPRToTopic(EndpointReferenceType endpointReferenceType, ISNotifier.GCUBENotificationTopic gCUBENotificationTopic, GCUBESecurityManager gCUBESecurityManager) {
        SubscribeToTopicResponse subscribeToTopicResponse = null;
        try {
            SubscribeMessage subscribeMessage = new SubscribeMessage();
            subscribeMessage.setEndpointReference(endpointReferenceType);
            subscribeMessage.setTopic(gCUBENotificationTopic.getTopicQName().toString());
            subscribeMessage.setPrecondition(gCUBENotificationTopic.getPrecondition());
            subscribeMessage.setSelection(gCUBENotificationTopic.getSelector());
            SubscribeToTopicHandler subscribeToTopicHandler = new SubscribeToTopicHandler(subscribeMessage, this.getScope(), gCUBESecurityManager);
            boolean bl = true;
            for (int i = 0; bl && i <= 4; ++i) {
                if (i > 0) {
                    Thread.sleep(20000L);
                }
                try {
                    subscribeToTopicHandler.run();
                    bl = false;
                    continue;
                }
                catch (Exception exception) {
                    logger.warn((Object)"error trying to register retrying in 20 secs", (Throwable)exception);
                }
            }
            subscribeToTopicResponse = (SubscribeToTopicResponse)subscribeToTopicHandler.getReturnValue();
            logger.trace((Object)("Trying to subscribe to topic" + gCUBENotificationTopic.getTopicQName() + " in " + this.getScope() + " with ERP " + endpointReferenceType.toString()));
        }
        catch (Exception exception) {
            logger.error((Object)"General Exception ", (Throwable)exception);
        }
        return subscribeToTopicResponse.getEndpointReference();
    }

    public void unsubscribeEPRFromTopic(EndpointReferenceType endpointReferenceType, ISNotifier.GCUBENotificationTopic gCUBENotificationTopic, GCUBESecurityManager gCUBESecurityManager) {
        try {
            SubscribeMessage subscribeMessage = new SubscribeMessage();
            subscribeMessage.setEndpointReference(endpointReferenceType);
            subscribeMessage.setTopic(gCUBENotificationTopic.getTopicQName().toString());
            subscribeMessage.setPrecondition(gCUBENotificationTopic.getPrecondition());
            subscribeMessage.setSelection(gCUBENotificationTopic.getSelector());
            new RemoveSubscriptionHandler(subscribeMessage, this.getScope(), gCUBESecurityManager).run();
            logger.trace((Object)("Trying to unsubscribe from topic" + gCUBENotificationTopic.toString()));
        }
        catch (Exception exception) {
            logger.error((Object)("General Exception " + exception));
        }
    }

    public String getCurrentNotificationMessageFromNotifier(EndpointReferenceType endpointReferenceType, QName qName, GCUBESecurityManager gCUBESecurityManager) throws Exception {
        GetCurrentMessageResponse getCurrentMessageResponse = null;
        try {
            TopicExpressionType topicExpressionType = new TopicExpressionType();
            topicExpressionType.setDialect("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple");
            topicExpressionType.setValue((Object)qName);
            WSBaseNotificationServiceAddressingLocator wSBaseNotificationServiceAddressingLocator = new WSBaseNotificationServiceAddressingLocator();
            NotificationProducer notificationProducer = wSBaseNotificationServiceAddressingLocator.getNotificationProducerPort(endpointReferenceType);
            GetCurrentMessage getCurrentMessage = new GetCurrentMessage();
            getCurrentMessage.setTopic(topicExpressionType);
            getCurrentMessageResponse = notificationProducer.getCurrentMessage(getCurrentMessage);
        }
        catch (Exception exception) {
            logger.error((Object)"Error trying to get Current Notification message ");
            return null;
        }
        return AnyHelper.toSingleString((AnyContentType)getCurrentMessageResponse);
    }

    private GCUBEScope getScope() {
        return this.scope;
    }
}

