/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.wps_hadoop.examples.gmtsar;

import com.terradue.jcatalogue.client.CatalogueClient;
import com.terradue.jcatalogue.client.DataSet;
import com.terradue.jcatalogue.client.HttpMethod;
import com.terradue.jcatalogue.client.Parameter;
import com.terradue.jcatalogue.client.download.DownloadHandler;
import com.terradue.wps_hadoop.common.AtomParser;
import com.terradue.wps_hadoop.common.StreamingAbstractAlgorithm;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.activation.MimetypesFileTypeMap;
import org.apache.abdera.Abdera;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.ExtensibleElement;
import org.apache.abdera.model.Feed;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.literal.LiteralStringBinding;

public class GMTSARAlgorithm
extends StreamingAbstractAlgorithm<LongWritable, Text> {
    private static Logger LOGGER = Logger.getLogger(GMTSARAlgorithm.class);
    private CatalogueClient catCl = null;
    private final Abdera abdera = new Abdera();
    public final String wpsLocation = String.valueOf(System.getProperty("catalina.base")) + "/webapps/wps/";
    private List<String> errors = new ArrayList<String>();
    public UUID SessionUID;
    public String inputTmpDirPath;

    public GMTSARAlgorithm() {
        this.renewClient();
    }

    public void renewClient() {
        this.catCl = new CatalogueClient();
        this.catCl.registerUmSsoCredentials(URI.create("https://eo-sso-idp.eo.esa.int/idp/umsso20/login?null"), HttpMethod.POST, new Parameter[]{new Parameter("cn", "fbarchetta"), new Parameter("password", ".fra$Ba04"), new Parameter("idleTime", "oneday"), new Parameter("sessionTime", "untilbrowserclose"), new Parameter("loginFields", "cn@password"), new Parameter("loginMethod", "umsso")});
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public Class getInputDataType(String id) {
        if (id.equals("Bbox")) {
            return ReferencedEnvelope.class;
        }
        return LiteralStringBinding.class;
    }

    public Class getOutputDataType(String id) {
        return LiteralStringBinding.class;
    }

    @Override
    protected void prepareToRun(Map<String, List<IData>> inputData) {
        this.hadoopConfig.addResource(new Path("/etc/hadoop/conf/core-site.xml"));
        this.hadoopConfig.addResource(new Path("/etc/hadoop/conf/hdfs-site.xml"));
        this.hadoopConfig.addResource(new Path("/etc/hadoop/conf/mapred-site.xml"));
    }

    @Override
    protected Map<String, IData> buildResults(Map<String, List<IData>> inputData) {
        String slave_href = "";
        try {
            String master = ((LiteralStringBinding)inputData.get("master").get(0)).getPayload();
            List<IData> slaves = inputData.get("slave");
            LOGGER.info((Object)("Deleting input path " + this.inputTmpDirPath));
            FileUtils.deleteDirectory((File)new File(this.inputTmpDirPath));
            Feed new_feed = this.abdera.newFeed();
            new_feed.setId(this.SessionUID.toString());
            File masterFile = new File(master);
            String[] splittedMaster = masterFile.getAbsolutePath().split("/");
            new_feed.setTitle("GMTSARAlgorithm processing results with Master file: " + splittedMaster[splittedMaster.length - 2]);
            int i = 0;
            File outputDir = new File(this.wpsLocation, "/store/outputs/");
            for (IData slaveIData : slaves) {
                this.hdfs.copyToLocalFile(new Path(String.valueOf(this.hdfsPrefix) + "/" + this.SessionUID + "_" + i), new Path(outputDir.getAbsolutePath()));
                String slave = ((LiteralStringBinding)slaveIData).getPayload();
                Feed feed = AtomParser.getFeed(new URL(slave));
                String[] keys = feed.getNamespaces().keySet().toArray(new String[feed.getNamespaces().size()]);
                int j = 0;
                while (j < keys.length) {
                    new_feed.declareNS((String)feed.getNamespaces().get(keys[j]), keys[j]);
                    ++j;
                }
                Entry entry = feed.getEntry(slave);
                Entry new_entry = new_feed.addEntry();
                File outputs = new File(outputDir, this.SessionUID + "_" + i);
                slave_href = "http://eo-virtual-archive4.esa.int/wps/store/outputs/" + this.SessionUID + "_" + i + "/" + outputs.list(new TgzFilenameFilter())[0];
                File outputFile = new File(outputs, outputs.list(new TgzFilenameFilter())[0]);
                long output_length = outputFile.length();
                long master_length = masterFile.length();
                if (entry == null) {
                    throw new RuntimeException("Cannot read entry from slave Atom file");
                }
                new_entry.setId(this.SessionUID + "_" + i);
                new_entry.setTitle("GMTSARAlgorithm processing results with Slave file: " + slave);
                new_entry.setUpdated(new Date());
                new_entry.setPublished(new Date());
                new_entry.addLink(slave_href, "enclosure", new MimetypesFileTypeMap().getContentType(outputFile), "", "", output_length);
                new_entry.addLink(master, "related", "application/atom+xml", "Master File used for processing", "", master_length);
                List exs = entry.getExtensions();
                for (ExtensibleElement ex : exs) {
                    new_entry.addExtension((Element)ex);
                }
                ++i;
            }
            new_feed.setUpdated(new Date());
            File output = new File(String.valueOf(outputDir.getAbsolutePath()) + "/" + this.SessionUID.toString());
            output.mkdirs();
            new_feed.writeTo(this.abdera.getWriterFactory().getWriterByMediaType("application/atom+xml"), (OutputStream)new FileOutputStream(output + "/" + this.SessionUID + ".atom"));
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        HashMap<String, IData> resulthash = new HashMap<String, IData>();
        resulthash.put("result", (IData)new LiteralStringBinding(slave_href));
        return resulthash;
    }

    @Override
    protected String[] getArguments(Map<String, List<IData>> inputData) {
        if (inputData == null || !inputData.containsKey("master")) {
            throw new RuntimeException("Error while allocating input parameters 'master'");
        }
        if (inputData == null || !inputData.containsKey("slave")) {
            throw new RuntimeException("Error while allocating input parameters 'slave'");
        }
        if (inputData == null || !inputData.containsKey("Bbox")) {
            throw new RuntimeException("Error while allocating input parameters 'Bbox'");
        }
        String master = ((LiteralStringBinding)inputData.get("master").get(0)).getPayload();
        ReferencedEnvelope Bbox = (ReferencedEnvelope)inputData.get("Bbox").get(0).getPayload();
        String bboxString = String.valueOf(Bbox.getMinX()) + "," + Bbox.getMinY() + "," + Bbox.getMaxX() + "," + Bbox.getMaxY();
        List<IData> slaves = inputData.get("slave");
        String urlsFile = "";
        LOGGER.info((Object)"Getting FileSystem from Configuration");
        try {
            this.hdfs = FileSystem.get((Configuration)this.hadoopConfig);
            this.hdfsPrefix = FileSystem.getDefaultUri((Configuration)this.hdfs.getConf()).toString();
            LOGGER.info((Object)("hdfsURI = " + this.hdfsPrefix));
            if (this.validateBBox(bboxString)) {
                urlsFile = this.createUrlsFile(master, slaves, bboxString);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String[] arguments = new String[]{"-input", urlsFile, "-output", String.valueOf(this.wpsLocation) + "/store/outputs/" + this.SessionUID, "-mapper", "/home/wps-hadoop/applications/gmtsar/run_wps.sh"};
        return arguments;
    }

    private String createUrlsFile(String master, List<IData> slaves, String bbox) throws IOException, RuntimeException {
        this.SessionUID = UUID.randomUUID();
        LOGGER.info((Object)("SessionUID = " + this.SessionUID));
        String result = "";
        LOGGER.info((Object)"Creating downloaderHandler");
        MyDownloadHandler downloadHandler = new MyDownloadHandler();
        System.setOut(new PrintStream(new FileOutputStream("/dev/null")));
        this.inputTmpDirPath = String.valueOf(this.wpsLocation) + "/store/inputs/" + this.SessionUID;
        LOGGER.info((Object)("Creating dirs " + this.inputTmpDirPath));
        if (!new File(this.inputTmpDirPath).mkdirs()) {
            throw new RuntimeException("Error creating dirs " + this.inputTmpDirPath);
        }
        URI masterURI = URI.create(master);
        LOGGER.info((Object)("Getting DataSet " + masterURI));
        DataSet masterDataSet = this.catCl.getDataSet(masterURI, new Parameter[0]);
        LOGGER.info((Object)"Downloading master DataSet...");
        masterDataSet.download(new File(this.inputTmpDirPath.toString()), (DownloadHandler)downloadHandler);
        LOGGER.info((Object)("File downloaded " + downloadHandler.getFile().getName()));
        String masterFileName = "/" + downloadHandler.getFile().getName();
        String finalMasterPath = String.valueOf(this.hdfsPrefix) + this.inputTmpDirPath + "/files" + masterFileName;
        LOGGER.info((Object)("Destination Master Path = " + finalMasterPath));
        LOGGER.info((Object)("Creating dirs " + this.inputTmpDirPath + "/files/"));
        if (!new File(String.valueOf(this.inputTmpDirPath) + "/files/").mkdirs()) {
            throw new RuntimeException("Error creating dirs " + this.inputTmpDirPath + "/files/");
        }
        LOGGER.info((Object)("Copying " + this.inputTmpDirPath.toString() + masterFileName + " to " + finalMasterPath));
        this.hdfs.copyFromLocalFile(true, true, new Path(String.valueOf(this.inputTmpDirPath.toString()) + masterFileName), new Path(finalMasterPath));
        int i = 0;
        for (IData slaveIData : slaves) {
            this.renewClient();
            LOGGER.info((Object)("Creating " + this.inputTmpDirPath + "/files/urls/input.urls_" + i));
            String urlsPath = String.valueOf(this.inputTmpDirPath) + "/files/urls/input.urls_" + i;
            new File(String.valueOf(this.inputTmpDirPath) + "/files/urls/").mkdirs();
            File urls = new File(urlsPath);
            BufferedWriter buff = new BufferedWriter(new FileWriter(urls));
            String slaveUID = this.SessionUID + "_" + i;
            LOGGER.info((Object)("slaveUID = " + slaveUID));
            ++i;
            LOGGER.info((Object)("Making dirs " + this.inputTmpDirPath + "/files/" + slaveUID));
            new File(String.valueOf(this.inputTmpDirPath) + "/files/" + slaveUID).mkdirs();
            LOGGER.info((Object)"Getting slave input");
            String slave = ((LiteralStringBinding)slaveIData).getPayload();
            URI slaveURI = URI.create(slave);
            LOGGER.info((Object)("slave URI created = " + slaveURI));
            LOGGER.info((Object)"Getting slave DataSet");
            DataSet slaveDataSet = this.catCl.getDataSet(slaveURI, new Parameter[0]);
            LOGGER.info((Object)("Downloading Slave DataSet into " + this.inputTmpDirPath.toString() + "/files/"));
            slaveDataSet.download(new File(String.valueOf(this.inputTmpDirPath.toString()) + "/files/" + slaveUID), (DownloadHandler)downloadHandler);
            String slaveFileName = "/" + downloadHandler.getFile().getName();
            String finalSlavePath = String.valueOf(this.hdfsPrefix) + this.inputTmpDirPath + "/files/" + slaveUID + slaveFileName;
            LOGGER.info((Object)("Copying " + this.inputTmpDirPath.toString() + slaveFileName + " to " + this.inputTmpDirPath + "/files/" + slaveUID));
            this.hdfs.copyFromLocalFile(true, true, new Path(String.valueOf(this.inputTmpDirPath.toString()) + "/files/" + slaveUID + slaveFileName), new Path(finalSlavePath));
            LOGGER.info((Object)"Writing into files.urls");
            LOGGER.info((Object)("Bounding box = " + bbox));
            buff.write(String.valueOf(slaveUID) + ";" + finalMasterPath + ";" + finalSlavePath + ";" + bbox + ";");
            buff.close();
            LOGGER.info((Object)("Copying " + urlsPath + " to " + this.hdfsPrefix + this.inputTmpDirPath + "/urls/input.urls_" + i));
            this.hdfs.copyFromLocalFile(true, true, new Path(urlsPath), new Path(String.valueOf(this.hdfsPrefix) + this.inputTmpDirPath + "/urls/input.urls_" + i));
        }
        result = String.valueOf(this.hdfsPrefix) + this.inputTmpDirPath + "/urls/";
        return result;
    }

    private boolean validateBBox(String bbox) {
        String[] values = bbox.split(",");
        if (values.length < 4) {
            throw new IllegalStateException("Error validating Bounding Box number of values");
        }
        try {
            double xmin = new Double(values[0]);
            double ymin = new Double(values[1]);
            double xmax = new Double(values[2]);
            double ymax = new Double(values[3]);
            if (xmin < -180.0 || xmin > 180.0) {
                throw new IllegalStateException("Error validating xmin in Bounding Box = " + xmin);
            }
            if (ymin < -90.0 || ymin > 90.0) {
                throw new IllegalStateException("Error validating ymin in Bounding Box = " + ymin);
            }
            if (xmax < -180.0 || xmax > 180.0) {
                throw new IllegalStateException("Error validating xmax in Bounding Box = " + xmax);
            }
            if (ymax < -90.0 || ymax > 90.0) {
                throw new IllegalStateException("Error validating ymax in Bounding Box = " + ymax);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("Error validating one of Bounding Box parameters " + e.getMessage());
        }
        return true;
    }

    private static final class MyDownloadHandler
    implements DownloadHandler {
        private File file;

        private MyDownloadHandler() {
        }

        public void onError(String message) {
            LOGGER.error((Object)message);
            throw new RuntimeException(message);
        }

        public void onError(Throwable t) {
            LOGGER.error((Object)t);
            throw new RuntimeException(t.getMessage());
        }

        public void onFatal(String message) {
            LOGGER.fatal((Object)message);
            throw new RuntimeException(message);
        }

        public void onCompleted(File file) {
            LOGGER.info((Object)("Download has succedeed in " + file.getAbsolutePath()));
            this.file = file;
        }

        public void onWarning(String message) {
            LOGGER.warn((Object)message);
        }

        public File getFile() {
            return this.file;
        }
    }

    private static final class TgzFilenameFilter
    implements FilenameFilter {
        private static final Pattern COMPRESSED_FORMAT = Pattern.compile(".+\\.(tgz|tar\\.gz)", 2);

        private TgzFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return COMPRESSED_FORMAT.matcher(name).matches();
        }
    }
}

