/*
 * Decompiled with CFR 0.152.
 */
package wssec;

import java.io.ByteArrayInputStream;
import java.io.PrintWriter;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.client.AxisClient;
import org.apache.axis.configuration.NullProvider;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.axis.security.util.AxisUtil;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.message.WSSignEnvelope;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;

public class TestWSSecurity11
extends TestCase {
    private static Log log = LogFactory.getLog(class$wssec$TestWSSecurity11 == null ? (class$wssec$TestWSSecurity11 = TestWSSecurity11.class$("wssec.TestWSSecurity11")) : class$wssec$TestWSSecurity11);
    static final String NS = "http://www.w3.org/2000/09/xmldsig#";
    static final String soapMsg = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body>\r\n       \r\n</SOAP-ENV:Envelope>";
    static final WSSecurityEngine secEngine = new WSSecurityEngine();
    static final Crypto crypto = CryptoFactory.getInstance("cryptoSKI.properties");
    MessageContext msgContext;
    SOAPEnvelope unsignedEnvelope;
    static /* synthetic */ Class class$wssec$TestWSSecurity11;

    public TestWSSecurity11(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(class$wssec$TestWSSecurity11 == null ? (class$wssec$TestWSSecurity11 = TestWSSecurity11.class$("wssec.TestWSSecurity11")) : class$wssec$TestWSSecurity11);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestWSSecurity11.suite());
    }

    protected void setUp() throws Exception {
        AxisClient tmpEngine = new AxisClient(new NullProvider());
        this.msgContext = new MessageContext(tmpEngine);
        this.unsignedEnvelope = this.getSOAPEnvelope();
    }

    protected SOAPEnvelope getSOAPEnvelope() throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(soapMsg.getBytes());
        Message msg = new Message(in);
        msg.setMessageContext(this.msgContext);
        return msg.getSOAPEnvelope();
    }

    public void testX509SignatureDirectSTR() throws Exception {
        Object envelope = null;
        WSSignEnvelope builder = new WSSignEnvelope();
        builder.setUserInfo("wss4jcert", "security");
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants(this.unsignedEnvelope.getAsDOM());
        Vector<WSEncryptionPart> parts = new Vector<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart(soapConstants.getBodyQName().getLocalPart(), soapConstants.getEnvelopeURI(), "Content");
        parts.add(encP);
        encP = new WSEncryptionPart("STRTransform", soapConstants.getEnvelopeURI(), "Content");
        parts.add(encP);
        builder.setParts(parts);
        builder.setKeyIdentifierType(1);
        log.info("Before Signing STR DirectReference....");
        Document doc = this.unsignedEnvelope.getAsDocument();
        Document signedDoc = builder.build(doc, crypto);
        Message signedMsg = (Message)AxisUtil.toSOAPMessage(signedDoc);
        if (log.isDebugEnabled()) {
            log.debug("Signed message with STR DirectReference key identifier:");
            XMLUtils.PrettyElementToWriter(signedMsg.getSOAPEnvelope().getAsDOM(), new PrintWriter(System.out));
        }
        signedDoc = signedMsg.getSOAPEnvelope().getAsDocument();
        log.info("After Signing STR DirectReference....");
        this.verify(signedDoc);
    }

    public void testX509SignatureISSTR() throws Exception {
        Object envelope = null;
        WSSignEnvelope builder = new WSSignEnvelope();
        builder.setUserInfo("wss4jcert", "security");
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants(this.unsignedEnvelope.getAsDOM());
        Vector<WSEncryptionPart> parts = new Vector<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart(soapConstants.getBodyQName().getLocalPart(), soapConstants.getEnvelopeURI(), "Content");
        parts.add(encP);
        encP = new WSEncryptionPart("STRTransform", soapConstants.getEnvelopeURI(), "Content");
        parts.add(encP);
        builder.setParts(parts);
        builder.setKeyIdentifierType(2);
        log.info("Before Signing STR IS....");
        Document doc = this.unsignedEnvelope.getAsDocument();
        Document signedDoc = builder.build(doc, crypto);
        Message signedMsg = (Message)AxisUtil.toSOAPMessage(signedDoc);
        if (log.isDebugEnabled()) {
            log.debug("Signed message with STR IssuerSerial key identifier:");
            XMLUtils.PrettyElementToWriter(signedMsg.getSOAPEnvelope().getAsDOM(), new PrintWriter(System.out));
        }
        signedDoc = signedMsg.getSOAPEnvelope().getAsDocument();
        log.info("After Signing STR IS....");
        this.verify(signedDoc);
    }

    public void testX509SignatureSKISTR() throws Exception {
        Object envelope = null;
        WSSignEnvelope builder = new WSSignEnvelope();
        builder.setUserInfo("wss4jcert", "security");
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants(this.unsignedEnvelope.getAsDOM());
        Vector<WSEncryptionPart> parts = new Vector<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart(soapConstants.getBodyQName().getLocalPart(), soapConstants.getEnvelopeURI(), "Content");
        parts.add(encP);
        encP = new WSEncryptionPart("STRTransform", soapConstants.getEnvelopeURI(), "Content");
        parts.add(encP);
        builder.setParts(parts);
        builder.setKeyIdentifierType(4);
        log.info("Before Signing STR SKI....");
        Document doc = this.unsignedEnvelope.getAsDocument();
        Document signedDoc = builder.build(doc, crypto);
        Message signedMsg = (Message)AxisUtil.toSOAPMessage(signedDoc);
        if (log.isDebugEnabled()) {
            log.debug("Signed message with STR SKI key identifier:");
            XMLUtils.PrettyElementToWriter(signedMsg.getSOAPEnvelope().getAsDOM(), new PrintWriter(System.out));
        }
        signedDoc = signedMsg.getSOAPEnvelope().getAsDocument();
        log.info("After Signing STR SKI....");
        this.verify(signedDoc);
    }

    private void verify(Document doc) throws Exception {
        secEngine.processSecurityHeader(doc, null, null, crypto);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

