/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.properties;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import org.apache.axis.message.MessageElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.NoSuchResourceException;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.ResourceProperties;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.ResourcePropertySet;
import org.globus.wsrf.WSRFConstants;
import org.globus.wsrf.impl.SimpleResourcePropertyMetaData;
import org.globus.wsrf.utils.FaultHelper;
import org.globus.wsrf.utils.Resources;
import org.oasis.wsrf.properties.DeleteType;
import org.oasis.wsrf.properties.InsertType;
import org.oasis.wsrf.properties.InvalidResourcePropertyQNameFaultType;
import org.oasis.wsrf.properties.InvalidSetResourcePropertiesRequestContentFaultType;
import org.oasis.wsrf.properties.ResourceUnknownFaultType;
import org.oasis.wsrf.properties.SetResourcePropertiesResponse;
import org.oasis.wsrf.properties.SetResourceProperties_Element;
import org.oasis.wsrf.properties.SetResourcePropertyRequestFailedFaultType;
import org.oasis.wsrf.properties.UnableToModifyResourcePropertyFaultType;
import org.oasis.wsrf.properties.UpdateType;

public class SetResourcePropertiesProvider {
    private static Log logger = LogFactory.getLog(SetResourcePropertiesProvider.class.getName());
    private static I18n i18n = I18n.getI18n(Resources.class.getName());

    public SetResourcePropertiesResponse setResourceProperties(SetResourceProperties_Element request) throws RemoteException, SetResourcePropertyRequestFailedFaultType, InvalidResourcePropertyQNameFaultType, UnableToModifyResourcePropertyFaultType, ResourceUnknownFaultType, InvalidSetResourcePropertiesRequestContentFaultType {
        if (request == null) {
            throw new RemoteException(i18n.getMessage("nullArgument", "request"));
        }
        Resource resource = null;
        try {
            resource = ResourceContext.getResourceContext().getResource();
        }
        catch (NoSuchResourceException e) {
            ResourceUnknownFaultType fault = new ResourceUnknownFaultType();
            FaultHelper faultHelper = new FaultHelper(fault);
            faultHelper.addFaultCause(e);
            throw fault;
        }
        catch (Exception e) {
            throw new RemoteException(i18n.getMessage("resourceDisoveryFailed"), e);
        }
        if (!(resource instanceof ResourceProperties)) {
            throw new RemoteException(i18n.getMessage("rpsNotSupported"));
        }
        ResourcePropertySet set = ((ResourceProperties)((Object)resource)).getResourcePropertySet();
        Object prop = null;
        Object rp = null;
        Object component = null;
        Iterator iter = request.iterator();
        while (iter.hasNext()) {
            component = iter.next();
            if (component instanceof DeleteType) {
                this.handleDelete(component, set);
                continue;
            }
            if (component instanceof InsertType) {
                this.handleInsert(component, set);
                continue;
            }
            if (component instanceof UpdateType) {
                this.handleUpdate(component, set);
                continue;
            }
            SetResourcePropertyRequestFailedFaultType fault = new SetResourcePropertyRequestFailedFaultType();
            FaultHelper faultHelper = new FaultHelper(fault);
            throw fault;
        }
        SetResourcePropertiesResponse response = new SetResourcePropertiesResponse();
        return response;
    }

    private void handleDelete(DeleteType delete, ResourcePropertySet set) throws InvalidResourcePropertyQNameFaultType, UnableToModifyResourcePropertyFaultType {
        QName rp = delete.getResourceProperty();
        if (rp == null) {
            InvalidResourcePropertyQNameFaultType fault = new InvalidResourcePropertyQNameFaultType();
            FaultHelper faultHelper = new FaultHelper(fault);
            faultHelper.setDescription(i18n.getMessage("noRPName"));
            throw fault;
        }
        this.checkRP(rp);
        ResourceProperty prop = set.get(rp);
        if (prop == null) {
            InvalidResourcePropertyQNameFaultType fault = new InvalidResourcePropertyQNameFaultType();
            FaultHelper faultHelper = new FaultHelper(fault);
            faultHelper.setDescription(rp.toString());
            throw fault;
        }
        try {
            prop.clear();
        }
        catch (RuntimeException e) {
            UnableToModifyResourcePropertyFaultType fault = new UnableToModifyResourcePropertyFaultType();
            FaultHelper faultHelper = new FaultHelper(fault);
            faultHelper.addFaultCause(e);
            faultHelper.setDescription(rp.toString());
            throw fault;
        }
    }

    private void handleInsert(InsertType insert, ResourcePropertySet set) throws InvalidResourcePropertyQNameFaultType, UnableToModifyResourcePropertyFaultType {
        MessageElement[] any = insert.get_any();
        if (any == null) {
            InvalidResourcePropertyQNameFaultType fault = new InvalidResourcePropertyQNameFaultType();
            FaultHelper faultHelper = new FaultHelper(fault);
            faultHelper.setDescription(i18n.getMessage("noRPName"));
            throw fault;
        }
        QName rp = null;
        ResourceProperty prop = null;
        for (int j = 0; j < any.length; ++j) {
            rp = SetResourcePropertiesProvider.getQName(any[j]);
            this.checkRP(rp);
            prop = set.get(rp);
            if (prop == null) {
                if (set.isOpenContent()) {
                    SimpleResourcePropertyMetaData metaData = new SimpleResourcePropertyMetaData(rp);
                    prop = set.create(metaData);
                    set.add(prop);
                } else {
                    InvalidResourcePropertyQNameFaultType fault = new InvalidResourcePropertyQNameFaultType();
                    FaultHelper faultHelper = new FaultHelper(fault);
                    faultHelper.setDescription(rp.toString());
                    throw fault;
                }
            }
            try {
                prop.add(any[j]);
                continue;
            }
            catch (RuntimeException e) {
                UnableToModifyResourcePropertyFaultType fault = new UnableToModifyResourcePropertyFaultType();
                FaultHelper faultHelper = new FaultHelper(fault);
                faultHelper.addFaultCause(e);
                faultHelper.setDescription(rp.toString());
                throw fault;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUpdate(UpdateType update, ResourcePropertySet set) throws InvalidResourcePropertyQNameFaultType, UnableToModifyResourcePropertyFaultType {
        MessageElement[] any = update.get_any();
        if (any == null) {
            InvalidResourcePropertyQNameFaultType fault = new InvalidResourcePropertyQNameFaultType();
            FaultHelper faultHelper = new FaultHelper(fault);
            faultHelper.setDescription(i18n.getMessage("noRPName"));
            throw fault;
        }
        QName rp = null;
        ResourceProperty prop = null;
        HashMap<QName, LinkedList<MessageElement>> updates = new HashMap<QName, LinkedList<MessageElement>>();
        for (int j = 0; j < any.length; ++j) {
            LinkedList<MessageElement> values;
            rp = SetResourcePropertiesProvider.getQName(any[j]);
            this.checkRP(rp);
            prop = set.get(rp);
            if (prop == null) {
                if (set.isOpenContent()) {
                    SimpleResourcePropertyMetaData metaData = new SimpleResourcePropertyMetaData(rp);
                    prop = set.create(metaData);
                    set.add(prop);
                } else {
                    InvalidResourcePropertyQNameFaultType fault = new InvalidResourcePropertyQNameFaultType();
                    FaultHelper faultHelper = new FaultHelper(fault);
                    faultHelper.setDescription(rp.toString());
                    throw fault;
                }
            }
            if ((values = (LinkedList<MessageElement>)updates.get(rp)) == null) {
                values = new LinkedList<MessageElement>();
                updates.put(rp, values);
            }
            values.add(any[j]);
        }
        Iterator iter = updates.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            rp = (QName)entry.getKey();
            prop = set.get(rp);
            if (prop == null) continue;
            ResourceProperty resourceProperty = prop;
            synchronized (resourceProperty) {
                try {
                    prop.clear();
                    Iterator listIter = ((List)entry.getValue()).iterator();
                    while (listIter.hasNext()) {
                        prop.add(listIter.next());
                    }
                }
                catch (RuntimeException e) {
                    UnableToModifyResourcePropertyFaultType fault = new UnableToModifyResourcePropertyFaultType();
                    FaultHelper faultHelper = new FaultHelper(fault);
                    faultHelper.addFaultCause(e);
                    faultHelper.setDescription(rp.toString());
                    throw fault;
                }
            }
        }
    }

    private void checkRP(QName rp) throws UnableToModifyResourcePropertyFaultType {
        if (rp.equals(WSRFConstants.CURRENT_TIME) || rp.equals(WSRFConstants.TERMINATION_TIME)) {
            UnableToModifyResourcePropertyFaultType fault = new UnableToModifyResourcePropertyFaultType();
            FaultHelper faultHelper = new FaultHelper(fault);
            faultHelper.setDescription(rp.toString());
            throw fault;
        }
    }

    public static QName getQName(SOAPElement element) {
        Name name = element.getElementName();
        return new QName(name.getURI(), name.getLocalName());
    }
}

