/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.handlers;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.globus.axis.description.ServiceDescUtil;
import org.globus.wsrf.config.ContainerConfig;

public class URLMapper
extends BasicHandler {
    public void invoke(MessageContext msgContext) throws AxisFault {
        if (msgContext.getTargetService() == null && msgContext.getService() == null) {
            this.setTargetService(msgContext, (String)msgContext.getProperty("transport.url"));
            if (msgContext.getService() != null) {
                ServiceDescUtil.resetOperations(msgContext);
            }
        }
    }

    public void generateWSDL(MessageContext msgContext) throws AxisFault {
        this.invoke(msgContext);
    }

    protected void setTargetService(MessageContext msgContext, String url) throws AxisFault {
        if (url == null) {
            return;
        }
        String path = null;
        try {
            path = new URL(url).getFile();
        }
        catch (MalformedURLException e) {
            throw AxisFault.makeFault(e);
        }
        AxisEngine engine = msgContext.getAxisEngine();
        ContainerConfig config = ContainerConfig.getConfig(engine);
        String base = config.getWSRFLocation();
        int len = base.length() + 1;
        if (path.startsWith("/" + base) && path.length() > len) {
            String service = path.substring(len);
            msgContext.setTargetService(service);
        }
    }
}

