/*
 * Decompiled with CFR 0.152.
 */
package org.globus.axis.transport.local;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.rpc.Stub;
import org.apache.axis.AxisEngine;
import org.apache.axis.MessageContext;
import org.apache.axis.client.Call;
import org.apache.axis.session.Session;

public class LocalTransportUtils {
    private static final String PROPERTIES = "contextProperties";
    private static final String[] PROPS = new String[]{"configPath", "home.dir"};

    public static void init() {
    }

    public static boolean enableLocalTransport(Stub stub) {
        MessageContext ctx = MessageContext.getCurrentContext();
        if (ctx == null) {
            return false;
        }
        if (!LocalTransportUtils.storeProperties(ctx)) {
            return false;
        }
        AxisEngine engine = ctx.getAxisEngine();
        stub._setProperty("LocalTransport.AxisServer", engine);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean storeProperties(MessageContext ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException();
        }
        AxisEngine engine = ctx.getAxisEngine();
        Session session = engine.getApplicationSession();
        if (session == null) {
            return false;
        }
        Object object = session.getLockObject();
        synchronized (object) {
            HashMap<String, Object> savedProps = (HashMap<String, Object>)session.get(PROPERTIES);
            if (savedProps == null) {
                savedProps = new HashMap<String, Object>();
                Object value = null;
                for (int i = 0; i < PROPS.length; ++i) {
                    value = ctx.getProperty(PROPS[i]);
                    if (value == null) continue;
                    savedProps.put(PROPS[i], value);
                }
                session.set(PROPERTIES, savedProps);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean restoreProperties(MessageContext ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException();
        }
        AxisEngine engine = ctx.getAxisEngine();
        Session session = engine.getApplicationSession();
        if (session == null) {
            return false;
        }
        Map savedProps = null;
        Object object = session.getLockObject();
        synchronized (object) {
            savedProps = (Map)session.get(PROPERTIES);
        }
        if (savedProps == null) {
            return false;
        }
        Iterator iter = savedProps.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ctx.setProperty((String)entry.getKey(), entry.getValue());
        }
        return true;
    }

    static {
        Call.addTransportPackage("org.apache.axis.transport");
    }
}

