/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.pkcs;

import java.math.BigInteger;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.KeyDerivationFunc;

public class PBKDF2Params
extends KeyDerivationFunc {
    DERObjectIdentifier id;
    ASN1OctetString octStr;
    DERInteger iterationCount;
    DERInteger keyLength;

    PBKDF2Params(ASN1Sequence aSN1Sequence) {
        super(aSN1Sequence);
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.id = (DERObjectIdentifier)enumeration.nextElement();
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)enumeration.nextElement();
        enumeration = aSN1Sequence2.getObjects();
        this.octStr = (ASN1OctetString)enumeration.nextElement();
        this.iterationCount = (DERInteger)enumeration.nextElement();
        this.keyLength = enumeration.hasMoreElements() ? (DERInteger)enumeration.nextElement() : null;
    }

    public byte[] getSalt() {
        return this.octStr.getOctets();
    }

    public BigInteger getIterationCount() {
        return this.iterationCount.getValue();
    }

    public BigInteger getKeyLength() {
        if (this.keyLength != null) {
            return this.keyLength.getValue();
        }
        return null;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.id);
        aSN1EncodableVector2.add(this.octStr);
        aSN1EncodableVector2.add(this.iterationCount);
        if (this.keyLength != null) {
            aSN1EncodableVector2.add(this.keyLength);
        }
        aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector2));
        return new DERSequence(aSN1EncodableVector);
    }
}

