/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.util.Arrays;
import java.util.HashMap;
import org.apache.naming.resources.CacheEntry;

public class ResourceCache {
    protected CacheEntry[] cache = new CacheEntry[0];
    protected HashMap notFoundCache = new HashMap();
    protected int cacheMaxSize = 10240;
    protected int maxAllocateIterations = 20;
    protected long desiredEntryAccessRatio = 3L;
    protected int spareNotFoundEntries = 500;
    protected int cacheSize = 0;
    protected long accessCount = 0L;
    protected long hitsCount = 0L;

    public long getAccessCount() {
        return this.accessCount;
    }

    public int getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    public void setCacheMaxSize(int n) {
        this.cacheMaxSize = n;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public long getDesiredEntryAccessRatio() {
        return this.desiredEntryAccessRatio;
    }

    public void setDesiredEntryAccessRatio(long l) {
        this.desiredEntryAccessRatio = l;
    }

    public long getHitsCount() {
        return this.hitsCount;
    }

    public int getMaxAllocateIterations() {
        return this.maxAllocateIterations;
    }

    public void setMaxAllocateIterations(int n) {
        this.maxAllocateIterations = n;
    }

    public int getSpareNotFoundEntries() {
        return this.spareNotFoundEntries;
    }

    public void setSpareNotFoundEntries(int n) {
        this.spareNotFoundEntries = n;
    }

    public boolean allocate(int n) {
        int n2;
        int n3;
        int n4 = n - (this.cacheMaxSize - this.cacheSize);
        if (n4 <= 0) {
            return true;
        }
        n4 += this.cacheMaxSize / 20;
        int n5 = this.notFoundCache.size();
        if (n5 > this.spareNotFoundEntries) {
            this.notFoundCache.clear();
            this.cacheSize -= n5;
            n4 -= n5;
        }
        if (n4 <= 0) {
            return true;
        }
        int n6 = 0;
        int n7 = 0;
        long l = 0L;
        int[] nArray = new int[this.maxAllocateIterations];
        while (n4 > 0) {
            if (n6 == this.maxAllocateIterations) {
                return false;
            }
            if (n4 > 0) {
                int n8 = -1;
                n3 = 0;
                n2 = 0;
                while (n3 == 0) {
                    n3 = 1;
                    n8 = (int)Math.floor(Math.random() * (double)(this.cache.length - 1));
                    int n9 = 0;
                    while (n9 < n7) {
                        if (nArray[n9] == n8) {
                            n3 = 0;
                        }
                        ++n9;
                    }
                }
                long l2 = this.cache[n8].accessCount * 100L / this.accessCount;
                if (l2 < this.desiredEntryAccessRatio) {
                    nArray[n7] = n8;
                    l += (long)this.cache[n8].size;
                    n4 -= this.cache[n8].size;
                    ++n7;
                }
            }
            ++n6;
        }
        Arrays.sort(nArray, 0, n7);
        CacheEntry[] cacheEntryArray = new CacheEntry[this.cache.length - n7];
        n3 = 0;
        n2 = -1;
        if (n7 > 0) {
            n2 = nArray[0];
            int n10 = 0;
            while (n10 < this.cache.length) {
                if (n10 == n2) {
                    if (n3 + 1 < n7) {
                        n2 = nArray[n3 + 1];
                        ++n3;
                    } else {
                        ++n3;
                        n2 = -1;
                    }
                } else {
                    cacheEntryArray[n10 - n3] = this.cache[n10];
                }
                ++n10;
            }
        }
        this.cache = cacheEntryArray;
        this.cacheSize = (int)((long)this.cacheSize - l);
        return true;
    }

    public CacheEntry lookup(String string) {
        CacheEntry cacheEntry = null;
        ++this.accessCount;
        int n = ResourceCache.find(this.cache, string);
        if (n != -1 && string.equals(this.cache[n].name)) {
            cacheEntry = this.cache[n];
        }
        if (cacheEntry == null) {
            try {
                cacheEntry = (CacheEntry)this.notFoundCache.get(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (cacheEntry != null) {
            ++this.hitsCount;
        }
        return cacheEntry;
    }

    public void load(CacheEntry cacheEntry) {
        if (cacheEntry.exists) {
            this.insertCache(cacheEntry);
        } else {
            this.notFoundCache.put(cacheEntry.name, cacheEntry);
        }
        this.cacheSize += cacheEntry.size;
    }

    public boolean unload(String string) {
        CacheEntry cacheEntry = this.removeCache(string);
        if (cacheEntry != null) {
            this.cacheSize -= cacheEntry.size;
            return true;
        }
        if (this.notFoundCache.remove(string) != null) {
            --this.cacheSize;
            return true;
        }
        return false;
    }

    private static final int find(CacheEntry[] cacheEntryArray, String string) {
        int n = 0;
        int n2 = cacheEntryArray.length - 1;
        if (n2 == -1) {
            return -1;
        }
        if (string.compareTo(cacheEntryArray[0].name) < 0) {
            return -1;
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        do {
            n3 = (n2 + n) / 2;
            int n4 = string.compareTo(cacheEntryArray[n3].name);
            if (n4 > 0) {
                n = n3;
                continue;
            }
            if (n4 == 0) {
                return n3;
            }
            n2 = n3;
        } while (n2 - n != 1);
        int n5 = string.compareTo(cacheEntryArray[n2].name);
        if (n5 < 0) {
            return n;
        }
        return n2;
    }

    private final boolean insertCache(CacheEntry cacheEntry) {
        CacheEntry[] cacheEntryArray = this.cache;
        int n = ResourceCache.find(cacheEntryArray, cacheEntry.name);
        if (n != -1 && cacheEntry.name.equals(cacheEntryArray[n].name)) {
            return false;
        }
        CacheEntry[] cacheEntryArray2 = new CacheEntry[this.cache.length + 1];
        System.arraycopy(cacheEntryArray, 0, cacheEntryArray2, 0, n + 1);
        cacheEntryArray2[n + 1] = cacheEntry;
        System.arraycopy(cacheEntryArray, n + 1, cacheEntryArray2, n + 2, cacheEntryArray.length - n - 1);
        this.cache = cacheEntryArray2;
        return true;
    }

    private final CacheEntry removeCache(String string) {
        CacheEntry[] cacheEntryArray = this.cache;
        int n = ResourceCache.find(cacheEntryArray, string);
        if (n != -1 && string.equals(cacheEntryArray[n].name)) {
            CacheEntry[] cacheEntryArray2 = new CacheEntry[this.cache.length - 1];
            System.arraycopy(cacheEntryArray, 0, cacheEntryArray2, 0, n);
            System.arraycopy(cacheEntryArray, n + 1, cacheEntryArray2, n, cacheEntryArray.length - n - 1);
            this.cache = cacheEntryArray2;
            return cacheEntryArray[n];
        }
        return null;
    }
}

