/*
 * Decompiled with CFR 0.152.
 */
package ise.library;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class FileUtilities {
    public static int BUFFER_SIZE = 8192;

    public static void copy(File from, File to) throws Exception {
        FileUtilities.copyFile(from, to);
    }

    public static void copy(InputStream is, File to) throws Exception {
        FileUtilities.copyToFile(is, to);
    }

    public static void copy(InputStream is, boolean close, File to) throws Exception {
        FileUtilities.copyToFile(is, close, to);
    }

    public static void copy(InputStream is, OutputStream os) throws Exception {
        FileUtilities.copyToStream(is, os);
    }

    public static void copy(Reader r, Writer w) throws Exception {
        FileUtilities.copyToWriter(r, w);
    }

    public static void copyFile(File from, File to) throws Exception {
        int bytes_read;
        if (!from.exists()) {
            return;
        }
        FileInputStream in = new FileInputStream(from);
        FileOutputStream out = new FileOutputStream(to);
        byte[] buffer = new byte[BUFFER_SIZE];
        while ((bytes_read = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytes_read);
        }
        out.flush();
        out.close();
        in.close();
    }

    public static void copyToFile(InputStream from, File to) throws Exception {
        FileUtilities.copyToFile(from, true, to);
    }

    public static void copyToFile(InputStream from, boolean close, File to) throws Exception {
        int bytes_read;
        FileOutputStream out = new FileOutputStream(to);
        byte[] buffer = new byte[BUFFER_SIZE];
        while ((bytes_read = from.read(buffer)) != -1) {
            out.write(buffer, 0, bytes_read);
        }
        out.flush();
        out.close();
        if (close) {
            from.close();
        }
    }

    public static void copyToStream(InputStream from, OutputStream to) throws Exception {
        int bytes_read;
        byte[] buffer = new byte[BUFFER_SIZE];
        while ((bytes_read = from.read(buffer)) != -1) {
            to.write(buffer, 0, bytes_read);
        }
        to.flush();
        from.close();
    }

    public static void copyToWriter(Reader from, Writer to) throws Exception {
        int chars_read;
        char[] buffer = new char[BUFFER_SIZE];
        while ((chars_read = from.read(buffer)) != -1) {
            to.write(buffer, 0, chars_read);
        }
        to.flush();
        from.close();
    }
}

