/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.transport;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSInputFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.bson.types.ObjectId;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.resource.StorageObject;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.util.DateUtils;
import org.gcube.contentmanagement.blobstorage.transport.util.MongoInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoClient
extends TransportManager {
    final Logger logger = LoggerFactory.getLogger(MongoClient.class);
    private String[] server;
    private Mongo mongo;
    private static MongoClient istance;

    public static MongoClient getIstance(String[] server) {
        if (istance == null) {
            istance = new MongoClient(server);
        }
        return istance;
    }

    private MongoClient(String[] server) {
        try {
            this.server = server;
            DB db = this.getDB();
            DBCollection coll = db.getCollection("fs.files");
            coll.createIndex((DBObject)new BasicDBObject("filename", (Object)1));
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (MongoException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Object get(MyFile resource, String serverLocation, Class<? extends Object> type) throws IOException {
        GridFSDBFile f;
        DB db = this.getDB();
        GridFS gfs = new GridFS(db);
        Class<? extends Object> o = type;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("MongoDB - pathServer: " + serverLocation);
        }
        if ((f = gfs.findOne(serverLocation)) == null) {
            try {
                BasicDBObject query = new BasicDBObject();
                query.put("_id", (Object)new ObjectId(serverLocation));
                f = gfs.findOne((DBObject)query);
            }
            catch (Exception e) {
                f = null;
            }
        }
        if (f != null) {
            String lock = (String)f.get("lock");
            if (lock == null || lock.isEmpty() || this.isTTLUnlocked(f)) {
                if (f.containsField("lock")) {
                    f.put("lock", null);
                    f.save();
                }
                this.download(resource, f, false);
            } else {
                this.checkTTL(f);
            }
        } else {
            this.mongo.close();
            throw new FileNotFoundException("REMOTE FILE NOT FOUND: WRONG PATH OR WRONG OBJECT ID");
        }
        return null;
    }

    private void checkTTL(GridFSDBFile f) throws IllegalAccessError {
        if (f.containsField("timestamp")) {
            long timestamp = (Long)f.get("timestamp");
            long currentTTL = System.currentTimeMillis() - timestamp;
            throw new IllegalAccessError("the file is locked currentTTL: " + currentTTL + "TTL bound " + 180000L);
        }
        this.checkTTL(f);
    }

    private boolean isTTLUnlocked(GridFSDBFile f) {
        if (f.get("timestamp") == null) {
            return true;
        }
        long timestamp = (Long)f.get("timestamp");
        System.out.println("timestamp found: " + timestamp);
        if (timestamp != 0L) {
            long currentTTL = System.currentTimeMillis() - timestamp;
            System.out.println("currentTTL: " + currentTTL + " TTL stabilito: " + 180000L);
            if (180000L < currentTTL) {
                f.put("timestamp", null);
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public String lock(MyFile resource, String serverLocation, Class<? extends Object> type) throws IOException {
        GridFSDBFile f;
        String key = null;
        DB db = this.getDB();
        GridFS gfs = new GridFS(db);
        Class<? extends Object> o = type;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("MongoDB - pathServer: " + serverLocation);
        }
        if ((f = gfs.findOne(serverLocation)) == null) {
            try {
                BasicDBObject query = new BasicDBObject();
                query.put("_id", (Object)new ObjectId(serverLocation));
                f = gfs.findOne((DBObject)query);
            }
            catch (Exception e) {
                f = null;
            }
        }
        if (f != null) {
            String lock = (String)f.get("lock");
            if (lock == null || lock.isEmpty() || this.isTTLUnlocked(f)) {
                key = f.getId() + "" + System.currentTimeMillis();
                f.put("lock", (Object)key);
                f.put("timestamp", (Object)System.currentTimeMillis());
                f.save();
            } else {
                this.checkTTL(f);
            }
        } else {
            this.mongo.close();
            throw new FileNotFoundException("REMOTE FILE NOT FOUND: WRONG PATH OR WRONG OBJECT ID");
        }
        return key;
    }

    @Override
    public String put(Object resource, String bucket, String key, boolean replace) throws UnknownHostException, MongoException {
        GridFSDBFile fold;
        DB db = this.getDB();
        GridFS gfs = new GridFS(db);
        String dir = ((MyFile)resource).getRemoteDir();
        String name = ((MyFile)resource).getName();
        String path = bucket;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("DIR: " + dir + " name: " + name + " fullPath " + path + " bucket: " + bucket);
        }
        if ((fold = gfs.findOne(path)) != null) {
            String oldir = (String)fold.get("dir");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("old dir  found " + oldir);
            }
            if (oldir.equalsIgnoreCase(((MyFile)resource).getRemoteDir())) {
                String lock;
                ObjectId oldId = (ObjectId)fold.getId();
                if (!replace) {
                    return oldId.toString();
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("remove id: " + oldId);
                }
                if ((lock = (String)fold.get("lock")) != null && !lock.isEmpty() && !this.isTTLUnlocked(fold)) {
                    throw new IllegalAccessError("The file is locked");
                }
                gfs.remove(oldId);
            }
        }
        GridFSInputFile f2 = null;
        try {
            if (((MyFile)resource).getInputStream() != null) {
                f2 = gfs.createFile(((MyFile)resource).getInputStream());
                ((MyFile)resource).getInputStream().close();
                ((MyFile)resource).setInputStream(null);
            } else {
                f2 = gfs.createFile(new File(((MyFile)resource).getPathClient()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Directory: " + dir);
        }
        f2.put("filename", (Object)bucket);
        f2.put("type", (Object)"file");
        f2.put("name", (Object)name);
        f2.put("dir", (Object)dir);
        f2.put("owner", (Object)((MyFile)resource).getOwner());
        f2.put("creationTime", (Object)DateUtils.now("dd MM yyyy 'at' hh:mm:ss z"));
        f2.save();
        Object id = f2.getId();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ObjectId: " + id);
        }
        this.buildDirTree(gfs, dir);
        this.mongo.close();
        return id.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String unlock(Object resource, String bucket, String key, String key4unlock) throws FileNotFoundException, UnknownHostException, MongoException {
        GridFSDBFile f;
        DB db = this.getDB();
        GridFS gfs = new GridFS(db);
        String dir = ((MyFile)resource).getRemoteDir();
        String name = ((MyFile)resource).getName();
        String path = bucket;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("DIR: " + dir + " name: " + name + " fullPath " + path + " bucket: " + bucket);
        }
        if ((f = gfs.findOne(path)) == null) {
            f = gfs.findOne(new ObjectId(path));
        }
        if (f == null) throw new FileNotFoundException(path);
        String oldir = (String)f.get("dir");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("old dir  found " + oldir);
        }
        if (!oldir.equalsIgnoreCase(((MyFile)resource).getRemoteDir()) && ((MyFile)resource).getRemoteDir() != null) throw new FileNotFoundException(path);
        String lock = (String)f.get("lock");
        if (lock == null || lock.isEmpty()) return null;
        String lck = (String)f.get("lock");
        if (!lck.equalsIgnoreCase(key4unlock)) throw new IllegalAccessError("bad key for unlock");
        f.put("lock", null);
        f.put("timestamp", null);
        f.save();
        return null;
    }

    @Override
    public Map getValues(String bucket, Class<? extends Object> type) throws UnknownHostException, MongoException {
        DB db = this.getDB();
        GridFS gfs = new GridFS(db);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Mongo get values of dir: " + bucket);
        }
        HashMap<Object, StorageObject> map = null;
        BasicDBObject query = new BasicDBObject();
        query.put("dir", (Object)bucket);
        List list = gfs.find((DBObject)query);
        for (GridFSDBFile f : list) {
            if (map == null) {
                map = new HashMap<Object, StorageObject>();
            }
            StorageObject s_obj = null;
            if (f.get("type") == null || f.get("type").toString().equalsIgnoreCase("file")) {
                String creationTime;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("found object: " + f.get("name") + "    type:  " + f.get("type"));
                }
                s_obj = new StorageObject(f.get("name").toString(), "file");
                String owner = (String)f.get("owner");
                if (owner != null) {
                    s_obj.setOwner(owner);
                }
                if ((creationTime = (String)f.get("creationTime")) != null) {
                    s_obj.setCreationTime(creationTime);
                }
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("found directory: " + f.get("name") + "    type:  " + f.get("type"));
                }
                s_obj = new StorageObject(f.get("name").toString(), "dir");
            }
            map.put(f.get("name"), s_obj);
        }
        this.mongo.close();
        return map;
    }

    @Override
    public void clearBucket(String bucket) throws UnknownHostException, MongoException {
        GridFSDBFile f;
        DB db = this.getDB();
        GridFS gfs = new GridFS(db);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Mongo delete bucket: " + bucket);
        }
        if ((f = gfs.findOne(bucket)) != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("fileFound\n remove file");
            }
            ObjectId id = (ObjectId)f.getId();
            gfs.remove(id);
        } else {
            ObjectId id;
            GridFSDBFile fID;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("File Not Found. Try to delete by ObjectID");
            }
            if (bucket.length() > 23 && (fID = gfs.findOne(id = new ObjectId(bucket))) != null) {
                String dir = (String)fID.get("dir");
                String filename = (String)fID.get("filename");
                gfs.remove(id);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("object deleted by ID");
                }
            }
        }
        this.mongo.close();
    }

    @Override
    public void removeKey(String bucket, String key) {
    }

    @Override
    public Map getValuesPredicate(String bucket, Class<? extends Object> type, String predicate) {
        return null;
    }

    @Override
    public void removeDir(String remoteDir) throws UnknownHostException, MongoException {
        DB db = this.getDB();
        GridFS gfs = new GridFS(db);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Mongo delete bucket: " + remoteDir);
        }
        BasicDBObject query = new BasicDBObject();
        String regex = remoteDir + "*";
        query.put("dir", (Object)Pattern.compile(regex));
        this.removeObject(gfs, query);
        query = new BasicDBObject();
        String[] dir = remoteDir.split("/");
        StringBuffer parentDir = new StringBuffer();
        for (int i = 0; i < dir.length - 1; ++i) {
            parentDir.append(dir[i] + "/");
        }
        String name = dir[dir.length - 1];
        query.put("dir", (Object)parentDir.toString());
        query.put("name", (Object)name);
        this.removeObject(gfs, query);
        this.mongo.close();
    }

    @Override
    public long getSize(String remotePath) throws UnknownHostException, MongoException {
        GridFSDBFile f;
        long length = -1L;
        DB db = this.getDB();
        GridFS gfs = new GridFS(db);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("MongoDB - pathServer: " + remotePath);
        }
        if ((f = gfs.findOne(remotePath)) != null) {
            length = f.getLength();
        }
        this.mongo.close();
        return length;
    }

    @Override
    public long getTTL(String remotePath) throws UnknownHostException, MongoException {
        GridFSDBFile f;
        long timestamp = -1L;
        long currentTTL = -1L;
        long remainsTTL = -1L;
        DB db = this.getDB();
        GridFS gfs = new GridFS(db);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("MongoDB - pathServer: " + remotePath);
        }
        if ((f = gfs.findOne(remotePath)) != null && (timestamp = ((Long)f.get("timestamp")).longValue()) > 0L) {
            currentTTL = System.currentTimeMillis() - timestamp;
            remainsTTL = 180000L - currentTTL;
        }
        this.mongo.close();
        return remainsTTL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long renewTTL(MyFile resource) throws UnknownHostException, MongoException, IllegalAccessException {
        String lock;
        long ttl = -1L;
        DB db = this.getDB();
        GridFS gfs = new GridFS(db);
        MyFile file = resource;
        String key = file.getLockedKey();
        String remotePath = file.getPathServer();
        GridFSDBFile f = gfs.findOne(remotePath);
        if (f != null && (lock = (String)f.get("lock")) != null && !lock.isEmpty()) {
            String lck = (String)f.get("lock");
            if (!lck.equalsIgnoreCase(key)) throw new IllegalAccessError("bad key for unlock");
            if (f.containsField("countRenew")) {
                int count = (Integer)f.get("countRenew");
                if (count >= 5) throw new IllegalAccessException("The number max of TTL renew reached. The number max is: 5");
                f.put("countRenew", (Object)(count + 1));
            } else {
                f.put("countRenew", (Object)1);
            }
            f.put("timestamp", (Object)System.currentTimeMillis());
            f.save();
            ttl = 180000L;
        }
        this.mongo.close();
        return ttl;
    }

    private void buildDirTree(GridFS gfs, String dir) {
        String[] dirTree = dir.split("/");
        StringBuffer strBuff = new StringBuffer();
        strBuff.append("/");
        for (int i = 1; i < dirTree.length; ++i) {
            BasicDBObject query = new BasicDBObject();
            query.put("name", (Object)dirTree[i]);
            query.put("dir", (Object)strBuff.toString());
            query.put("type", (Object)"dir");
            GridFSDBFile f = gfs.findOne((DBObject)query);
            if (f == null) {
                byte[] data = new byte[1];
                GridFSInputFile f3 = gfs.createFile(data);
                f3.put("name", (Object)dirTree[i]);
                f3.put("dir", (Object)strBuff.toString());
                f3.put("type", (Object)"dir");
                f3.save();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(" Create new  object with name: " + dirTree[i] + " dir: " + strBuff.toString() + " type= dir");
                }
            }
            strBuff.append(dirTree[i] + "/");
        }
    }

    private void download(MyFile resource, GridFSDBFile f, boolean isLock) throws IOException {
        if (resource.getPathClient() != null && !resource.getPathClient().isEmpty()) {
            this.writeByPath(resource, f, isLock);
            this.mongo.close();
        } else if (resource.getOutputStream() != null) {
            this.writeByOutputStream(resource, f, isLock);
            this.mongo.close();
        }
        if (resource != null && resource.getType() != null && resource.getType().equalsIgnoreCase("input")) {
            this.writeByInputStream(resource, f, isLock);
        }
    }

    private String writeByInputStream(MyFile resource, GridFSDBFile f, boolean isLock) {
        String key = null;
        resource.setInputStream((InputStream)((Object)new MongoInputStream(this.mongo, f.getInputStream())));
        f.save();
        return key;
    }

    private String writeByOutputStream(MyFile resource, GridFSDBFile f, boolean isLock) throws IOException {
        String key = null;
        f.writeTo(resource.getOutputStream());
        resource.setOutputStream(null);
        f.save();
        return key;
    }

    private String writeByPath(MyFile resource, GridFSDBFile f, boolean isLock) throws IOException {
        String key = null;
        f.writeTo(resource.getPathClient());
        resource.setPathClient(null);
        f.save();
        return key;
    }

    private void removeObject(GridFS gfs, BasicDBObject query) {
        List list = gfs.find((DBObject)query);
        for (GridFSDBFile f : list) {
            if (f != null) {
                String name = (String)f.get("name");
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("fileFound\n remove file " + name);
                }
                ObjectId id = (ObjectId)f.getId();
                gfs.remove(id);
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("File Not Found");
        }
    }

    private DB getDB() throws UnknownHostException, MongoException {
        DB db = null;
        for (String srv : this.server) {
            try {
                this.mongo = new Mongo(srv);
                db = this.mongo.getDB("remotefs");
                GridFS gfs = new GridFS(db);
                this.server[0] = srv;
                break;
            }
            catch (Exception e) {
            }
        }
        return db;
    }
}

