/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.operation;

import java.io.OutputStream;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.BucketCoding;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.StringEncrypter;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.service.operation.Operation;

public class GetUrl
extends Operation {
    private OutputStream os;

    public GetUrl(String[] server, String bucket, Monitor monitor, boolean isChunk) {
        super(server, bucket, monitor, isChunk);
    }

    @Override
    public Object doIt(MyFile myFile) throws IllegalAccessException {
        String urlBase = "smp:/" + myFile.getPathServer() + "?";
        String urlParam = "";
        try {
            urlParam = new StringEncrypter("DES").encrypt("ServiceClass=" + myFile.getServiceClass() + "&ServiceName=" + myFile.getServiceName() + "&owner=" + myFile.getOwnerGcube() + "&scope=" + myFile.getGcubeScope() + "&AccessType=" + myFile.getGcubeAccessType());
        }
        catch (StringEncrypter.EncryptionException e) {
            e.printStackTrace();
        }
        this.logger.info("URL generated: " + urlBase + urlParam);
        return urlBase + urlParam;
    }

    @Override
    public String initOperation(MyFile file, String remotePath, String author, String[] server, String rootArea, boolean replaceOption) {
        String buck = null;
        BucketCoding bc = new BucketCoding();
        buck = bc.mergingPathAndFile(rootArea, remotePath);
        return buck;
    }

    @Override
    public String initOperation(MyFile resource, String RemotePath, String author, String[] server, String rootArea) {
        return null;
    }
}

